package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



/**
   Delays incoming/outgoing messages by a random number of milliseconds (range between 0 and n 
   where n is determined by the user). Incoming messages can be delayed independently from
   outgoing messages (or not delayed at all).<p>
   This protocol should be inserted directly above the bottommost protocol (e.g. UDP).
 */

public class DELAY extends Protocol {
    boolean  trace=false;
    int      in_delay=0, out_delay=0;

    /** All protocol names have to be unique ! */
    public String  GetName() {return "DELAY";}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;

	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}

	str=props.getProperty("in_delay");
	if(str != null) {
	    in_delay=new Integer(str).intValue();
	    props.remove("in_delay");
	}

	str=props.getProperty("out_delay");
	if(str != null) {
	    out_delay=new Integer(str).intValue();
	    props.remove("out_delay");
	}

	if(props.size() > 0) {
	    System.err.println("DELAY.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }




    public void Up(Event evt) {
	int delay=in_delay > 0 ? ComputeDelay(in_delay) : 0;


	switch(evt.GetType()) {
	case Event.MSG:         // Only delay messages, not other events !
	    if(trace)
		System.out.println("DELAY: delaying incoming message for " + delay +
				   " milliseconds");
	    Util.Sleep(delay);	    
	    break;
	}
	
	PassUp(evt);            // Pass up to the layer above us
    }





    public void Down(Event evt) {
	int delay=out_delay > 0 ? ComputeDelay(out_delay) : 0;

	switch(evt.GetType()) {

	case Event.MSG:         // Only delay messages, not other events !
	    if(trace)
		System.out.println("DELAY: delaying outgoing message for " + delay +
				   " milliseconds");
	    Util.Sleep(delay);
	    break;
	}

	PassDown(evt);          // Pass on to the layer below us
    }

    
    /** Compute a random number between 0 and n */
    int ComputeDelay(int n) {
	return (int)((Math.random() * 1000000) % n);
    }


}
