
import java.io.*;
import JavaGroups.*;




/**
   Uses PullPush building block to send/receive messages. Reception is passive, e.g. the receiver's
   Receive() method is invoked whenever a message is received. The receiver has to register a callback method
   when creating the channel.
 */
public class PullPushTest implements MessageListener {
    private Channel          channel;
    private PullPushAdapter  adapter;

    public void Receive(Message msg) {
	System.out.println("Received msg: " + msg);
    }

    public Object GetState() {  // only called if channel option GET_STATE_EVENTS is set to true
	return null;
    }

    public void SetState(Object state) {
	
    }


    public void Start() throws Exception {
	channel=new JChannel();
	channel.Connect("PullPushTest");
	adapter=new PullPushAdapter(channel);
	adapter.SetListener(this);
	
	for(int i=0; i < 10; i++) {
	    System.out.println("Sending msg #" + i);
	    channel.Send(new Message(null, null, new String("Hello world").getBytes()));
	    Thread.currentThread().sleep(1000);
	}
	channel.Close();
    }


    public static void main(String args[]) {
	PullPushTest t=new PullPushTest();
	try {
	    t.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

}
