import java.io.*;
import java.util.*;

import JavaGroups.*;




/**
   Tests the fragmentation protocol (FRAG). A large message is broadcast to the group (sender does not
   receive its own broadcasts, though). The fragmentation protocol fragments messages bigger than
   8K and reassembles them at the receiver. Messages sent are 100K in size.
 */
public class FragTest {
    int         mode=0;  // 0=receiver, 1=sender
    Channel     channel;
    String      props="UDP:PING:FD:STABLE:NAKACK:UNICAST:" +
	              "FRAG(trace=true;frag_size=8096):FLUSH:GMS:VIEW_ENFORCER:QUEUE";
    int         i=1;
    Message     msg;
    Object      obj;
    final int   MSG_SIZE=100000;
    String      groupname="FragTestGroup";



    public FragTest(int mode) {
	this.mode=mode;
    }
    
    public void Start() throws Exception {
	channel=new JChannel(props);
	if(mode == 1) channel.SetOpt(Channel.LOCAL, new Boolean(false));
	channel.Connect(groupname);

	if(mode == 1) {
	    while(true) {
		msg=CreateBigMessage(MSG_SIZE);
		System.out.println("Sending msg (" + MSG_SIZE + " bytes)");
		channel.Send(msg);
		Thread.currentThread().sleep(5000);
	    }
	}
	else {
	    System.out.println("Waiting for messages:");
	    
	    while(true) {
		try {
		    obj=channel.Receive(0);
		    if(obj instanceof Message)
			System.out.println("Received message: " + obj);
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	}
    }



    Message CreateBigMessage(int size) {
	byte[] buf=new byte[size];
	for(int i=0; i < buf.length; i++) buf[i]=5;
	return new Message(null, null, buf);
    }

    

    public static void main(String[] args) {
	if(args.length != 1 || (!args[0].equals("sender") && !args[0].equals("receiver"))) {
	    System.err.println("FragTest <sender | receiver>");
	    return;
	}
	try {
	    new FragTest(args[0].equals("sender")? 1 : 0).Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

}
