
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;


import JavaGroups.*;
import JavaGroups.Event;




/**
   Shared whiteboard, each new instance joins the same group. Each instance chooses a random color,
   mouse moves are broadcast to all group members, which then apply them to their canvas.
 */
public class Draw implements Runnable, MouseMotionListener, WindowListener, ActionListener {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private DataInputStream        instream;
    private Random                 random=new Random(System.currentTimeMillis());
    private Button                 clear_button, leave_button;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private String                 groupname="DrawGroup";
    private Channel                channel=null;
    private Thread                 receiver=null;
    private int                    member_size=1;
    private int                    red=0, green=0, blue=0;
    private Color                  default_color=null;
    //private boolean                blocked=false;

 
    public Draw(ChannelFactory factory, String props) throws Exception {
	channel=factory.CreateChannel(props);
	// channel.SetOpt(Channel.BLOCK, new Boolean(true));
	// System.out.println("props=" + props);
    }


    public static void main(String[] args) {
	Draw             draw=null;
	ChannelFactory   factory=new JChannelFactory();
	String           arg, next_arg;
	String           logfile=null;
	String           props=null;
    

	try {
	    
	    //	    props="UDP:PING:FD:STABLE:DISCARD(down=0.1;trace=true):NAKACK(retransmit_timeout=1000):"+
	    //  "UNICAST(trace=true):FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE(trace=true)";

	    props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS(trace=true):VIEW_ENFORCER:QUEUE";

	    //  props="TUNNEL(router_host=localhost;router_port=8080):" +
	    //        "PING(router_host=localhost;router_port=8080):" + 
	    //        "FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS(trace=true):VIEW_ENFORCER:QUEUE";

	    for(int i=0; i < args.length; i++) {
		arg=args[i];
		if(arg.equals("-type")) {
		    next_arg=args[++i];
		    if(next_arg.equals("ens")) {
			props=null;
			factory=new EnsChannelFactory();
			continue;
		    }
		    else if(next_arg.equals("ibus")) {
			factory=(ChannelFactory)Class.forName("JavaGroups.IbusChannelFactory").newInstance();
			continue;
		    }
		}
		else if(arg.equals("-help")) {
		    System.out.println("Draw [-type ens | ibus ]");
		    return;
		}
	    }


	}
	catch(Exception e) {
	    System.out.println("Creation of channel factory failed, reason is: " + e);
	    return;
	}
	try {
	    draw=new Draw(factory, props);
	    draw.go();
	}
	catch(Exception e) {
	    System.err.println(e);
	    System.exit(0);
	}
    }




    private void SelectColor() {
	red=(Math.abs(random.nextInt()) % 255);
	green=(Math.abs(random.nextInt()) % 255);
	blue=(Math.abs(random.nextInt()) % 255);
	default_color=new Color(red, green, blue);
    }


	
    public void go() {
	try {
	    channel.Connect(groupname);
	    receiver=new Thread(this, "DrawThread");
	    receiver.setPriority(Thread.MAX_PRIORITY);
	    receiver.start();
	    mainFrame=new Frame();
	    panel=new Panel();
	    sub_panel=new Panel();
	    mainFrame.setSize(200,200);
	    mainFrame.add("Center", panel);
	    clear_button=new Button("Clear");
	    clear_button.setFont(default_font);
	    clear_button.addActionListener(this);
	    leave_button=new Button("Leave & Exit");
	    leave_button.setFont(default_font);
	    leave_button.addActionListener(this);
	    sub_panel.add("South", clear_button);
	    sub_panel.add("South", leave_button);
	    mainFrame.add("South", sub_panel);
	    mainFrame.addWindowListener(this);
	    panel.addMouseMotionListener(this);
	    mainFrame.setVisible(true);
	    mainFrame.setTitle(member_size + " mbrs");
	    graphics=panel.getGraphics();
	    SelectColor();
	    graphics.setColor(default_color);
	    mainFrame.setBackground(Color.white);
	    clear_button.setForeground(Color.blue);
	    leave_button.setForeground(Color.blue);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }


    public void run() {
	Object       tmp;
	Message      msg=null;
	DrawCommand  comm;
	boolean      fl=true;

	while(fl) {
	    try {
		tmp=channel.Receive(0);
		
		if(tmp == null) continue;
		
		if(tmp instanceof View) {
		    View v=(View)tmp;
		    member_size=v.Size();
		    if(mainFrame != null)
			mainFrame.setTitle(member_size + " mbrs");
		    
		    //System.out.println("Draw: received VIEW. Resuming sending data...");
		    //blocked=false;
		    continue;
		}
		
//    		if(tmp instanceof BlockEvent) {
//    		    System.out.println("Draw: received BLOCK event. Stopping sending data...");
//    		    blocked=true;
//    		    channel.BlockOk();
//    		}
		

		if(!(tmp instanceof Message))
		    continue;

		msg=(Message)tmp;
		comm=null;

		Object obj=Util.ObjectFromByteBuffer(msg.GetBuffer());

		if(obj instanceof DrawCommand)
		    comm=(DrawCommand)obj;
		else if(obj instanceof Message) {
		    System.out.println("*** Message is " + Util.PrintMessage((Message)obj));
		    Util.DumpStack(true);
		}
		else {
		    System.out.println("obj is " + obj.getClass());
		    Util.DumpStack(true);
		}

		switch(comm.mode) {
		case DrawCommand.DRAW:
		    if(graphics != null) {
			graphics.setColor(new Color(comm.r, comm.g, comm.b));
			graphics.fillOval(comm.x, comm.y, 10, 10);
			graphics.setColor(default_color);
		    }
		    break;
		case DrawCommand.CLEAR:
		    ClearPanel();
		    continue;
		default:
		    System.err.println("***** Draw.run(): received invalid draw command " + comm.mode);
		    return;
		}

	    }
	    catch(ChannelNotConnected not) {
		System.err.println("Draw: " + not);
		break;
	    }
	    catch(ChannelClosed closed) {
		return;
	    }
	    catch(Exception e) {
		System.err.println(e);
		continue; // break;
	    }
	}
    }


    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {
	int                 x=e.getX(), y=e.getY();
	DrawCommand         comm=new DrawCommand(DrawCommand.DRAW, x, y, red, green, blue);
	ObjectOutputStream  os;

	//if(blocked)
	//  return;

	try {
	    out.reset();
	    os=new ObjectOutputStream(out);
	    os.writeObject(comm);
	    os.flush();
	    channel.Send(new Message(null, null, out.toByteArray()));
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }


    public void ClearPanel() {
	Rectangle  bounds=null;
	if(panel == null || graphics == null)
	    return;

	bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }


    public void SendClearPanelMsg() {
	int                  tmp[]=new int[1]; tmp[0]=0;
	DrawCommand          comm=new DrawCommand(DrawCommand.CLEAR);
	ObjectOutputStream   os;

	try {
	    out.reset();
	    os=new ObjectOutputStream(out);
	    os.writeObject(comm);
	    os.flush();
	    channel.Send(new Message(null, null, out.toByteArray()));
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }




    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);  // exit the dirty way ...
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	String     command=e.getActionCommand();	
	if(command == "Clear")
	    SendClearPanelMsg();
	else if(command == "Leave & Exit") {
	    try {
		channel.Disconnect();
		channel.Close();
	    }
	    catch(Exception ex) {
		System.err.println(ex);
	    }
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }




}






class DrawCommand implements Serializable {
    static final int DRAW=1;
    static final int CLEAR=2;
    int mode;
    int x=0;
    int y=0;
    int r=0;
    int g=0;
    int b=0;

    DrawCommand(int mode) {
	this.mode=mode;
    }

    DrawCommand(int mode, int x, int y, int r, int g, int b) {
	this.mode=mode;
	this.x=x;
	this.y=y;
	this.r=r;
	this.g=g;
	this.b=b;
    }


    public String toString() {
	StringBuffer ret=new StringBuffer();
	switch(mode) {
	case DRAW: ret.append("DRAW(" + x + ", " + y + ") [" + r + "|" + g + "|" + b + "]");
	    break;
	case CLEAR: ret.append("CLEAR");
	    break;
	default:
	    return "<undefined>";
	}
	return ret.toString();
    }
}
