

import JavaGroups.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;


/**
   Instances of the group can broadcast short messages to the group, and receive them. A special button
   (LeaveJoin()) leaves the group and the re-joins it.
 */
public class Chat implements MouseListener, WindowListener, MessageListener, MembershipListener {
    private static Chat selfRef;

    Channel          channel;
    PullPushAdapter  ad;
    Thread           mainThread;
    int              portNumber;
    String           group_name = "ChatGroup";
    String           props=null;



    public Chat(int f) {
        portNumber = f;
    }

    public Chat() {}

    public static void main(String[] args) {
	selfRef = new Chat();
	selfRef.go();
    }

    Frame mainFrame;
    TextArea ta;
    TextField tf;
    Label csLabel;
    Button ltjButton;
    Button castButton;
    Button sendButton;
    Button rnvButton;


	
    public void go() {
	mainFrame = new Frame();
	mainFrame.setLayout(null);
	mainFrame.setSize(432,507);
	mainFrame.addWindowListener(this);

	ta = new TextArea();
	ta.setBounds(12,36,408,348);
	ta.setEditable(false);
	mainFrame.add(ta);

	tf = new TextField();
	tf.setBounds(108,392,240,24);
	mainFrame.add(tf);

	csLabel = new Label("Cast/Send:");
	csLabel.setBounds(12,392,85,18);
	mainFrame.add(csLabel);

	ltjButton = new Button("LeaveThenJoin");
	ltjButton.setBounds(24,428,108,25);
	ltjButton.addMouseListener(this);
	mainFrame.add(ltjButton);

	castButton = new Button("Cast");
	castButton.setBounds(144,428,86,25);
	castButton.addMouseListener(this);
	mainFrame.add(castButton);

	sendButton = new Button("Send");
	sendButton.setBounds(240,428,86,25);
	sendButton.addMouseListener(this);
	sendButton.setEnabled(false);
	mainFrame.add(sendButton);		
	mainFrame.show();
		
	try {
	    channel=new JChannel(props);
	    channel.Connect(group_name);
	    ad=new PullPushAdapter(channel, this, this);
	}
	catch(Exception e) {
	    ta.append(e.toString());
	}
    }



    /* -------------------- Interface MessageListener ------------------- */

    public void Receive(Message msg) {
	Object o;

	try {
	    o=Util.ObjectFromByteBuffer(msg.GetBuffer());
	    ta.append("Received: " + o.toString() + "' from " + msg.GetSrc() + "\n");
	}
	catch(Exception e) {
	    ta.append("Receive(): " + e);
	}
    }

    public Object GetState() {
	return null;
    }

    public void SetState(Object state) {}

    /* ----------------- End of Interface MessageListener --------------- */





    /* ------------------- Interface MembershipListener ----------------- */

    public void ViewAccepted(View new_view) {
	ta.append("Received view " + new_view + "\n");
    }


    public void Suspect(Object suspected_mbr) {
	
    }


    public void Block() {
	
    }

    /* --------------- End of Interface MembershipListener -------------- */



    
    private void handleLTJ() {
	try {
	    ad.Stop();
	    channel.Disconnect();
	    channel.Close();
	    channel=new JChannel(props);
	    channel.Connect(group_name);
	    ad=new PullPushAdapter(channel, this, this);
	    ta.append("successfully rejoined the group"+ "\n");	
	}
	catch(Exception e) {
	    ta.append("Failed rejoined the group: " + e.toString());
	}
    }

    private void handleCast() {
	Message msg = new Message(null, null, tf.getText());
	
	try {
	    channel.Send(msg);
	    ta.append("Multicasted: " + tf.getText() + "\n");
	}
	catch(Exception e) {
	    ta.append("Failed casting: " + e.toString());
	}
    }

    private void handleSend() {
    }

    public void mouseClicked(MouseEvent e) {
	Object obj = e.getSource();
		
	if (obj == ltjButton) {
	    handleLTJ();
	} else if (obj == castButton) {
	    handleCast();
	} else if (obj == sendButton) {
	    handleSend();
	}
    }

    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}

    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	if(ad != null) {
	    ad.Stop();
	    ad=null;
	}
	if(channel != null) {
	    channel.Close();
	    channel=null;
	}
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

// End class Chat
}
