package JavaGroups;

import java.io.*;
import java.util.*;

/**
   Keeps elements in sorted order (ascending or decending).
   Elements have to implement interface <code>Comparable</code>. Duplicate elements are discarded.
 */
public class SortedList extends List {

    public SortedList() {}



    /**
       Adds an object in sorted order.
     */
    public void Add(Object obj) {
	Element  el=new Element(obj);

	if(!(obj instanceof Comparable)) {
	    System.err.println("SortedList.Add(): object has to implement interface Comparable !");
	    return;
	}

	synchronized(mutex) {
	    if(head == null) { // no element in the list yet
		head=el;
		tail=head;
		size=1;
	    }
	    else {
		if(AddAscending(obj))
		    size++;
	    }
	}
    }



    /** Add <code>obj</code> in sorted order, discard duplicates. Starts comparing at the en, based on the
	assumption that most elements will be already in order (that is, last element added is biggest).
    */
    boolean AddAscending(Object obj) {
	int      comp;
	Element  el=tail, new_el=new Element(obj);
	
	while(el != null) {
	    comp=((Comparable)obj).Compare(el.obj);
	    //System.out.println("Compare(" + obj + ", " + el.obj + "): rc=" + comp);
	    if(comp == 0)        // duplicate
		return false;
	    else if(comp > 0) {  // new element is bigger
		new_el.next=el.next;
		new_el.prev=el;
		if(el.next != null)
		    el.next.prev=new_el;
		el.next=new_el;
		if(el == tail)
		    tail=new_el;
		return true;
	    }
	    else                 // new element is smaller
		;
	    el=el.prev;
	}

	AddAtHead(obj);  // at this point no element was smaller than 'obj'; therefore add it at the head
	return true;
    }



    public static void main(String args[]) {
	SortedList l=new SortedList();

	class MyString implements Comparable {
	    String s;
	    MyString(String s) {
		this.s=s;
	    }
	    public int Compare(Object other) {
		return s.compareTo(((MyString)other).s);
	    }
	    public String toString() {return s;}
	}


	if(args.length < 1) {
	    System.out.println("SortedList <strings>");
	    return;
	}

	for(int i=0; i < args.length; i++)
	    l.Add(new MyString(args[i]));


	for(Enumeration e=l.Elements(); e.hasMoreElements();)
	    System.out.print(e.nextElement() + " ");
	System.out.println();

	

    }
    





}
