package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



/**
   Queuing layer. Upon reception of event START_QUEUEING, all events traveling through
   this layer upwards/downwards (depending on direction of event) will be queued. Upon
   reception of a STOP_QUEUEING event, all events will be released. Finally, the
   queueing flag is reset.
   When queueing, only event STOP_QUEUEING (received up or downwards) will be allowed
   to release queueing.
*/

public class QUEUE extends Protocol {
    boolean   trace=false;
    Vector    up_queue=new Vector();
    Vector    dn_queue=new Vector();
    boolean   queueing_up=false, queueing_dn=false;

    /** All protocol names have to be unique ! */
    public String  GetName() {return "QUEUE";}


    public Vector ProvidedUpServices() {
	Vector ret=new Vector();
	ret.addElement(new Integer(Event.START_QUEUEING));
	ret.addElement(new Integer(Event.STOP_QUEUEING));
	return ret;
    }

    public Vector ProvidedDownServices() {
	Vector ret=new Vector();
	ret.addElement(new Integer(Event.START_QUEUEING));
	ret.addElement(new Integer(Event.STOP_QUEUEING));
	return ret;
    }


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}
	if(props.size() > 0) {
	    System.err.println("QUEUE.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }



    /**
       Queues or passes up events. No queue sync. necessary, as this method is never called
       concurrently.
     */
    public void Up(Event evt) {
	Message msg;
	Vector  event_list;  // to be passed up *before* replaying event queue
	Event   e;



	switch(evt.GetType()) {

	case Event.START_QUEUEING:  // start queueing all up events
	    if(trace) System.out.println("QUEUE.Up(): received START_QUEUEING");
	    queueing_up=true;
	    return;

	case Event.STOP_QUEUEING:         // stop queueing all up events
	    event_list=(Vector)evt.GetArg();
	    if(event_list != null)
		for(int i=0; i < event_list.size(); i++)
		    PassUp((Event)event_list.elementAt(i));
	    
	    if(trace) System.out.println("QUEUE.Up(): replaying up events");
	    
	    for(int i=0; i < up_queue.size(); i++) {
		e=(Event)up_queue.elementAt(i);		

		if(trace) {
		    if(e.GetType() == Event.MSG) {
			try {
			    Message m=(Message)e.GetArg();			    
			    Object o=Util.ObjectFromByteBuffer(((Message)m).GetBuffer());
			    System.out.println(o);
			}
			catch(Exception ex) {
			    System.err.println(ex);
			}
		    }
		}

		PassUp(e);
	    }

	    up_queue.removeAllElements();
	    queueing_up=false;
	    return;
	}
	
	if(queueing_up) {
	    if(trace) {
		System.out.println("QUEUE.Up(): queued up event " + evt);
	    }
	    up_queue.addElement(evt);
	}
	else
	    PassUp(evt);            // Pass up to the layer above us
    }




    
    public void Down(Event evt) {
	Message msg;
	Vector  event_list;  // to be passed down *before* replaying event queue
	
	switch(evt.GetType()) {
	    
	case Event.START_QUEUEING:  // start queueing all down events
	    if(trace) System.out.println("QUEUE.Down(): received START_QUEUEING");
	    queueing_dn=true;
	    return;

	case Event.STOP_QUEUEING:         // stop queueing all down events

	    if(trace) System.out.println("QUEUE.Down(): received STOP_QUEUEING");

	    event_list=(Vector)evt.GetArg();
	    if(event_list != null)  // play events first (if available)
		for(int i=0; i < event_list.size(); i++)
		    PassDown((Event)event_list.elementAt(i));

	    if(trace) System.out.println("QUEUE.Down(): replaying down events ("+
					 dn_queue.size() +")");

	    for(int i=0; i < dn_queue.size(); i++) {
		PassDown((Event)dn_queue.elementAt(i));
	    }

	    dn_queue.removeAllElements();
	    queueing_dn=false;
	    return;
	}


	    
	if(queueing_dn) {
	    if(trace)
		System.out.println("QUEUE.Down(): queued down event: " + Util.PrintEvent(evt));
	    dn_queue.addElement(evt);
	}
	else
	    PassDown(evt);          // Pass up to the layer below us
    }



}
