package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;








public class CoordGmsImpl extends GmsImpl {
    static CoordGmsImpl  impl=null;
    boolean                 leaving=false;
    Object                  leave_mutex=new Object();



    public static CoordGmsImpl CreateInstance(GMS gms) {
	if(impl == null)
	    impl=new CoordGmsImpl();
	impl.gms=gms;
	impl.leaving=false;
	return impl;
    }



    public void Join(Address mbr) {
	WrongMethod("Join");
    }



    public void Leave(Address mbr) {
	if(mbr.equals(gms.local_addr))
	    leaving=true;
	synchronized(leave_mutex) {
	    HandleLeave(mbr, false); // regular leave
	    try {
		leave_mutex.wait(gms.leave_timeout);
	    }
	    catch(Exception e) {}
	}
    }



    public void Suspect(Address mbr) {
	HandleSuspect(mbr);
    }


    public void Merge(Vector new_mbrs) {
	
    }




    public synchronized boolean HandleJoin(Address mbr) {
	Vector    new_mbrs=new Vector();

	if(gms.trace) System.out.println("\nCoord.HandleJoin(" + mbr + ")");

	if(gms.local_addr.equals(mbr)) {
	    System.err.println("CoordGmsImpl.Join(): cannot join myself !");
	    return false;
	}
	if(gms.members.Contains(mbr)) {
	    if(gms.trace)
		System.err.println("CoordGmsImpl.Join(): member " + mbr + " already present !");
	    return true;  // already joined
	}

	new_mbrs.addElement(mbr);
	gms.CastViewChange(new_mbrs, null, null);
	return true;
    }


    

    
    /**
       Exclude <code>mbr</code> from the membership. If <code>suspected</code> is true, then
       this member crashed and therefore is forced to leave, otherwise it is leaving voluntarily.
     */
    public synchronized void HandleLeave(Address mbr, boolean suspected) {
	Vector v=new Vector();  // contains either leaving mbrs or suspected mbrs
	if(!gms.members.Contains(mbr)) {
	    if(gms.trace) System.err.println("Coord.HandleLeave(" + mbr + "): not a member !");
	    return;
	}
	v.addElement(mbr);	
	if(suspected)
	    gms.CastViewChange(null, null, v);
	else
	    gms.CastViewChange(null, v, null);
    }




    public void HandleViewChange(ViewId new_view, Vector mbrs) {
	if(leaving) {
	    if(mbrs.contains(gms.local_addr)) {
		System.err.println("CoordGmsImpl.HandleViewChange(): received view in which I'm " +
				   "still a member, cannot quit yet");
		gms.InstallView(new_view, mbrs);  // +++ modify
	    }
	    else {
		synchronized(leave_mutex) {
		    leave_mutex.notify();
		}
	    }
	    return;
	}
	gms.InstallView(new_view, mbrs);  // +++ modify
    }



    public void HandleMerge(Vector new_mems, Vector suspects, long other_ltime) {
	System.out.println("CoordGmsImpl.HandleMerge(): not implemented yet !");
    }



    public void HandleSuspect(Address mbr) {
	if(mbr.equals(gms.local_addr)) {
	    System.err.println("I am the coord and am suspected: am not quitting !");
	    return;
	}
	HandleLeave(mbr, true); // irregular leave - forced
    }

}
