import java.io.*;
import java.util.*;


import JavaGroups.*;



/**
   Demos the UNICAST protocol. As soon as we have 2 members in a group, a destination member is randomly
   chosen (not self !). Then, as long as that destination member is member of the group, we send unicast
   messages to it. The sample protocol stack below has a DISCARD protocol in it, which randomly discards
   both unicast and multicast messages (in the example below, down messages are discarded with a probability
   of 10%, i.e. 1 out of 10 messages is discarded)).
 */
public class UnicastTest implements Runnable {
    Channel channel;
    String  groupname="UnicastTestGroup";
    String  props="UDP:PING:FD:DISCARD(trace=true;down=0.1):NAKACK(retransmit_timeout=1000):"+
	          "UNICAST(trace=true):FRAG:FLUSH:GMS(trace=true):VIEW_ENFORCER:QUEUE";
    Thread  writer=null;
    Vector  mbrs=new Vector();




    public void Start() throws Exception {
	Object  obj;
	Message msg;
	View    view;
	Vector  tmp;

	channel=new JChannel(props);
	channel.Connect(groupname);

	while(true) {
	    try {
		obj=channel.Receive(0);
		if(obj instanceof View) {
		    view=(View)obj;
		    tmp=view.GetMembers();
		    mbrs.removeAllElements();
		    for(int i=0; i < tmp.size(); i++)
			mbrs.addElement(tmp.elementAt(i));
		    

		    if(mbrs.size() > 1) {
			if(writer == null || !writer.isAlive()) {
			    writer=new Thread(this, "WriterThread");
			    writer.start();
			}
		    }
		    else {
			if(writer != null) {
			    writer.stop();
			    writer=null;
			}
		    }


		}
		else if(obj instanceof Message) {
		    msg=(Message)obj;
		    System.out.println("Received msg from " + msg.GetSrc());
		}
		else
		    ;
	    }
	    catch(ChannelClosed closed) {
		System.err.println("Channel closed");
		break;
	    }
	    catch(ChannelNotConnected not_conn) {
		System.err.println("Channel not connected");
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}




    }


    Object SelectTarget() {
	Vector tmp=new Vector();
	Object ret;
	int    t;

	if(mbrs == null || mbrs.size() < 2)
	    return null;

	for(int i=0; i < mbrs.size(); i++) {
	    if(!(mbrs.elementAt(i).equals(channel.GetLocalAddress())))
		tmp.addElement(mbrs.elementAt(i));
	}
	t=(int)((Math.random() * 100));
	ret=tmp.elementAt(t % tmp.size());
	return ret;
    }


    public void run() {
	Object target=SelectTarget();
	
	if(target == null)
	    return;

	while(true) {
	    try {
		System.out.println("Sending message to " + target);
		channel.Send(new Message(target, null, "Hello from " + channel.GetLocalAddress()));
		writer.sleep(2000);
	    }
	    catch(ChannelClosed closed) {
		System.err.println(closed);
		break;
	    }
	    catch(ChannelNotConnected not_conn) {
		System.err.println(not_conn);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}

    }


    public static void main(String[] args) {
	try {
	    new UnicastTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
