
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import JavaGroups.*;



/**
   Used in conjunction with QuoteServer: a client is member of a group of quote servers which replicate
   stock quotes among themselves. The client broadcasts its request (set, get quotes) and (in the case of get
   waits for the first reply received (usually the one from the quote server closest to it). The client
   can get and set quotes as long as a minimum of 1 server (in the group) is running.
 */
public class QuoteClient extends Frame implements WindowListener, ActionListener, 
						  MembershipListener {
    final String   channel_name="Quotes";
    RpcDispatcher  disp;
    Channel        channel;
    Button         get=new Button("Get"), set=new Button("Set");
    Button         quit=new Button("Quit"), get_all=new Button("All");
    Label          stock=new Label("Stock"), value=new Label("Value");
    Label          err_msg=new Label("Error");
    TextField      stock_field=new TextField(), value_field=new TextField();
    java.awt.List  listbox=new java.awt.List();
    final Font     default_font=new Font("Helvetica",Font.PLAIN,12);
    String         props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:"+
	                 "VIEW_ENFORCER:STATE_TRANSFER:QUEUE";



    public QuoteClient() {
	super();
	try {
	    channel=new JChannel(props);
	    channel.SetOpt(Channel.LOCAL, new Boolean(false));
	    disp=new RpcDispatcher(channel, null, this, this);
	    channel.Connect(channel_name);
	}
	catch(Exception e) {
	    System.err.println("QuoteClient(): " + e);
	}
	addWindowListener(this);
    }

    private void ShowMsg(String msg) {
	err_msg.setText(msg);
	err_msg.setVisible(true);
    }

    private void ClearMsg() {
	err_msg.setVisible(false);
    }


    public void Start() {
	setLayout(null);
	setSize(400, 300);
	setFont(default_font);

	stock.setBounds(new Rectangle(10, 30, 60, 30));
	value.setBounds(new Rectangle(10, 60, 60, 30));
	stock_field.setBounds(new Rectangle(100, 30, 100, 30));
	value_field.setBounds(new Rectangle(100, 60, 100, 30));
	listbox.setBounds(210, 30, 150, 160);
	err_msg.setBounds(new Rectangle(10, 200, 350, 30));
	err_msg.setFont(new Font("Helvetica",Font.ITALIC,12));
	err_msg.setForeground(Color.red);
	err_msg.setVisible(false);
	get.setBounds(new Rectangle(10, 250, 80, 30));
	set.setBounds(new Rectangle(100, 250, 80, 30));
	quit.setBounds(new Rectangle(190, 250, 80, 30));
	get_all.setBounds(new Rectangle(280, 250, 80, 30));

	get.addActionListener(this);
	set.addActionListener(this);
	quit.addActionListener(this);
	get_all.addActionListener(this);

	add(stock); add(value);
	add(stock_field); add(value_field);
	add(err_msg);
	add(get); add(set); add(quit); add(get_all);
	add(listbox);
	// stock_field.requestFocus();     
	setVisible(true);
    }



    public void windowActivated(WindowEvent e)   {}
    public void windowClosed(WindowEvent e)      {}
    public void windowClosing(WindowEvent e)     {System.exit(0);}
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e)   {}
    public void windowOpened(WindowEvent e)      {}


    public void actionPerformed(ActionEvent e) {
	String   command=e.getActionCommand();
	RspList  rsp_list;

	try {
	    if(command == "Get") {
		String stock_name=stock_field.getText();
		if(stock_name == null || stock_name.length() == 0) {
		    ShowMsg("Stock name is empty !");
		    return;
		}
		ShowMsg("Looking up value for " + stock_name + ":");
		rsp_list=disp.CallRemoteMethods(null, "GetQuote", stock_name, GroupRequest.GET_FIRST, 0);
		Float val=(Float)rsp_list.elementAt(0);
		if(val != null) {
		    value_field.setText(val.toString());
		    ClearMsg();
		}
		else {
		    value_field.setText("");
		    ShowMsg("Value for " + stock_name + " not found");
		}
	    }
	    else if(command == "Set") {
		String stock_name=stock_field.getText();
		String stock_val=value_field.getText();
		if(stock_name == null || stock_val == null || stock_name.length() == 0 ||
		   stock_val.length() == 0) {
		    ShowMsg("Stock name and value have to be present to enter a new value");
		    return;
		}
		Float val=new Float(stock_val);
		disp.CallRemoteMethods(null, "SetQuote", stock_name, val, GroupRequest.GET_FIRST, 0);
		ShowMsg("Stock " + stock_name + " set to " + val);
	    }
	    else if(command == "All") {
		listbox.removeAll();
		ShowMsg("Getting all stocks:");
		rsp_list=disp.CallRemoteMethods(null, "GetAllStocks", GroupRequest.GET_FIRST, 0);

		System.out.println("rsp_list is " + rsp_list);


		Hashtable all_stocks=(Hashtable)rsp_list.GetFirst();
		if(all_stocks == null) {
		    ShowMsg("No stocks found");
		    return;
		}
		ClearMsg();
		listbox.removeAll();
		String key;
		Float val;
		for(Enumeration en=all_stocks.keys(); en.hasMoreElements();) {
		    key=(String)en.nextElement();
		    val=(Float)all_stocks.get(key);
		    if(val == null)
			continue;
		    listbox.add(key + ": " + val.toString());
		}
	    }
	    else if(command == "Quit") {
		setVisible(false);
		channel.Close();
		System.exit(0);
	    }
	    else
		System.out.println("Unknown action");
	}
	catch(Exception ex) {
	    value_field.setText("");
	    ShowMsg(ex.toString());
	}
    }


    public void ViewAccepted(View new_view) {
	setTitle("Members in " + channel_name + ": " + (new_view.Size() -1));
    }

    public void Suspect(Object suspected_mbr) {}

    public void Block() {}

    
    public static void main(String args[]) {
	QuoteClient client=new QuoteClient();
	client.Start();
    }
	
}
