package JavaGroups;


import java.util.*;

/**
   Dispatches and receives remote group method calls. Is the equivalent of RpcProtocol
   on the application rather than protocol level.
 */
public class RpcDispatcher extends MessageDispatcher implements ChannelListener {
    final MethodLookup  method_lookup_clos=new MethodLookupClos();
    protected Object    server_obj=null;


    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
	super(channel, l, l2);
	channel.SetChannelListener(this);
	this.server_obj=server_obj;
    }


    public String GetName() {return "RpcDispatcher";}


    public RspList CastMessage(Vector dests, Message msg, int mode, long timeout) {
	System.err.println("RpcDispatcher.CastMessage(): this method should not be used with " +
			   "RpcDispatcher, but MessageDispatcher ! Returning null !");
	return null;
    }

    public Object SendMessage(Message msg, int mode, long timeout) throws Timeout, Suspected {
	System.err.println("RpcDispatcher.SendMessage(): this method should not be used with " +
			   "RpcDispatcher, but MessageDispatcher ! Returning null !");
	return null;
    }




    public RspList CallRemoteMethods(Vector dests, String method_name, int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }


    public RspList CallRemoteMethods(Vector dests, String method_name, Object arg1, 
				     int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name, arg1);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }


    public RspList CallRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, 
				     int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }


    public RspList CallRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2,
				     Object arg3, int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2, arg3);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }



    public RspList CallRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
	byte[]   buf=null;
	Message  msg=null;

	try {
	    buf=Util.ObjectToByteBuffer(method_call);
	}
	catch(Exception e) {
	    System.err.println("RpcProtocol.CallRemoteMethods(): " + e);
	    return null;
	}

	msg=new Message(null, null, buf);
	return super.CastMessage(dests, msg, mode, timeout);
    }





    public Object CallRemoteMethod(Object dest, String method_name, int mode, long timeout) 
	throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }


    public Object CallRemoteMethod(Object dest, String method_name, Object arg1, int mode, long timeout) 
	throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name, arg1);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }

    
    public Object CallRemoteMethod(Object dest, String method_name, Object arg1, Object arg2, 
				int mode, long timeout) throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }


    public Object CallRemoteMethod(Object dest, String method_name, Object arg1, Object arg2, 
				   Object arg3, int mode, long timeout) throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2, arg3);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }


    public Object CallRemoteMethod(Object dest, MethodCall method_call, int mode, long timeout) 
	throws Timeout, Suspected {
	byte[]   buf=null;
	Message  msg=null;

	try {
	    buf=Util.ObjectToByteBuffer(method_call);
	}
	catch(Exception e) {
	    System.err.println("RpcProtocol.CallRemoteMethod(): " + e);
	    return null;
	}

	msg=new Message(dest, null, buf);
	return super.SendMessage(msg, mode, timeout);
    }





    /**
       Message contains MethodCall. Execute it against *this* object and return result.
       Use MethodCall.Invoke() to do this. Return result.
     */
    public Object Handle(Message req) {
	Object      body=null, retval=null;
	MethodCall  method_call;


	if(server_obj == null) {
	    System.err.println("RpcDispatcher.Handle(): no method handler is registered ! " +
			       "Discarding request.");
	    return null;
	}

	if(req == null || req.GetBuffer() == null) {
	    System.err.println("RpcProtocol.Handle(): message or message buffer is null !");
	    return null;
	}

	try {
	    body=Util.ObjectFromByteBuffer(req.GetBuffer());
	}
	catch(Exception e) {
	    System.err.println("RpcProtocol.Handle(): " + e);
	    return null;
	}

	if(body == null || !(body instanceof MethodCall)) {
	    System.err.println("RpcProtocol.Handle(): message does not contain a MethodCall object !");
	    return null;
	}

	method_call=(MethodCall)body;
	retval=method_call.Invoke(server_obj, method_lookup_clos);
	return retval;
    }


    /* --------------------- Interface ChannelListener ---------------------- */

    public void ChannelConnected(Channel channel) {
	Start();
    }

    public void ChannelDisconnected(Channel channel) {
	Stop();
    }

    public void ChannelClosed(Channel channel) {
	Stop();
    }
    /* ----------------------------------------------------------------------- */

}
