package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

public class ParticipantGmsImpl extends GmsImpl {
    static ParticipantGmsImpl     impl=null;
    boolean                       leaving=false;
    boolean                       received_final_view=false;
    Object                        leave_mutex=new Object();
    


    private ParticipantGmsImpl() {}

    public static ParticipantGmsImpl CreateInstance(GMS gms) {
	if(impl == null)
	    impl=new ParticipantGmsImpl();
	impl.gms=gms;
	impl.leaving=false;
	impl.received_final_view=false;
	return impl;
    }





    public void Join(Address mbr) {
	WrongMethod("Join");
    }


    /**
       Loop: determine coord. If coord is me --> HandleLeave(). Else send HandleLeave() to coord until
       success.
     */
    public void Leave(Address mbr) {
	Address   coord;
	Boolean   retval=null;

	if(mbr.equals(gms.local_addr))
	    leaving=true;

	while((coord=gms.DetermineCoordinator()) != null && !received_final_view) {
	    synchronized(leave_mutex) {
		if(gms.local_addr.equals(coord)) {  // I'm the coordinator
		    gms.SetImpl(CoordGmsImpl.CreateInstance(gms));
		    gms.HandleLeave(mbr, false);  // regular leave
		}
		else {
		    try {
			System.out.println("Part.Leave(): sending LEAVE request to " + coord);
			gms.CallRemoteMethod(coord, "HandleLeave", mbr, new Boolean(false),
					     GroupRequest.GET_NONE, 0);  // asynchronous
			System.out.println("Part: sent leave request; waiting for view change");
		    }
		    catch(Exception e) {}
		}

		try {
		    leave_mutex.wait(gms.leave_timeout);
		    System.out.println("WAIT DONE -- can leave now");
		}
		catch(Exception e) {}

	    }
	}

	gms.SetImpl(ClientGmsImpl.CreateInstance(gms)); // become client ?????
    }




    public void Suspect(Address mbr) {
	HandleSuspect(mbr);
    }



    public void Merge(Vector new_mbrs) {
	HandleMerge(new_mbrs, null, 0);
    }


    public boolean HandleJoin(Address mbr) {
	WrongMethod("HandleJoin");
	return false;
    }


    public void HandleLeave(Address mbr, boolean suspected) {
	WrongMethod("HandleLeave");
    }


    
    /**
       If we are leaving, we have to wait for the view change (last msg in the current view) that
       excludes us before we can leave.
     */
    public void HandleViewChange(ViewId new_view, Vector mbrs) {
	if(leaving) {
	    if(mbrs.contains(gms.local_addr)) {
		System.err.println("ParticipantGmsImpl.HandleViewChange(): received view in "+
				   "which I'm still a member, cannot quit yet");
		gms.InstallView(new_view, mbrs);
	    }
	    else {
		synchronized(leave_mutex) {
		    received_final_view=true;
		    leave_mutex.notify();
		}
	    }
	    return;
	}
	gms.InstallView(new_view, mbrs);
    }




    public void HandleMerge(Vector new_mbrs, Vector suspects, long other_ltime) {
	Object coord;

	System.out.println("Part.HandleMerge()");

	synchronized(gms.view_mutex) {
	    gms.ltime=Math.max(gms.ltime, other_ltime) + 1;
	    gms.members.Merge(new_mbrs, suspects);
	    gms.members.Sort();
	    coord=gms.DetermineCoordinator();
	    if(coord != null && coord.equals(gms.local_addr)) {        // I'm the new coordinator
		gms.SetImpl(CoordGmsImpl.CreateInstance(gms));
		gms.CastViewChange(null, null, suspects);
	    }
	}
    }


    public void HandleSuspect(Address mbr) {
	Object coord=gms.DetermineCoordinator();
	
	if(coord != null && coord.equals(mbr)) {                   // coordinator is suspected
	    gms.members.Remove(mbr);
	    coord=gms.DetermineCoordinator();
	    if(coord != null && coord.equals(gms.local_addr)) {    // I'm the new coordinator

		System.out.println("Part.HandleSuspect(" + mbr + "), members are " + gms.members +
				   ", coord=" + coord + ": I'm the new coord !");
		

		Vector suspects=new Vector();
		gms.SetImpl(CoordGmsImpl.CreateInstance(gms));
		suspects.addElement(mbr);
		gms.CastViewChange(null, null, suspects);
	    }
	}
    }



    
}
