package JavaGroups.JavaStack.Protocols;



import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;






class MergeHeader implements Serializable {
    public static final int HELLO=1;          // arg = null

    public int    type=0;

    public MergeHeader(int type) {
	this.type=type;
    }

    public String toString() {
	return "[MERGE: type=" + Type2Str(type) + "]";
    }

    String Type2Str(int t) {
	switch(t) {
	case HELLO:        return "HELLO";
	default:           return "<unkown type (" + t + ")>";
	}
    }
}




/**
   Periodically mcasts a HELLO message with its own address. When a HELLO message is received
   from a member that has the same group (UDP discards all messages with a group name different that our
   own), but is not currently in the group, a MERGE event is sent up the stack. 
   The protocol starts working upon receiving a BECOME_SERVER event.
 */

public class MERGE extends Protocol implements Runnable {
    boolean         trace=false;
    Vector          members=new Vector();
    Address         local_addr=null;
    String          group_addr=null;
    String          groupname=null;
    Thread          hello_thread=null;       // thread that periodically mcasts HELLO messages
    long            timeout=5000;            // timeout between mcasting of HELLO messages
    String          gossip_host=null;
    int             gossip_port=0;
    GossipClient    gossip=null;
    boolean         is_server=false;



    public String  GetName() {return "MERGE";}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}

	str=props.getProperty("timeout");              // max time to wait for initial members
	if(str != null) {
	    timeout=new Long(str).longValue();
	    props.remove("timeout");
	}


	str=props.getProperty("gossip_host");          // host to send gossip queries (if gossip enabled)
	if(str != null) {
	    gossip_host=new String(str);
	    props.remove("gossip_host");
	}

	str=props.getProperty("gossip_port");
	if(str != null) {
	    gossip_port=new Integer(str).intValue();
	    props.remove("gossip_port");
	}

	if(gossip_host != null && gossip_port != 0)
	    gossip=new GossipClient(gossip_host, gossip_port);

	    

	if(props.size() > 0) {
	    System.err.println("MERGE.SetProperties(): the following properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }





    public void Up(Event evt) {
	Message      msg, rsp_msg;
	Object       obj;
	MergeHeader   hdr, rsp_hdr;
	PingRsp      rsp;
	Object       coord;
	Address      sender;
	boolean      contains;
	Vector       tmp;


	switch(evt.GetType()) {

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    obj=msg.PeekHeader();
	    	    if(obj == null || !(obj instanceof MergeHeader)) {
		PassUp(evt);
		return;
	    }
	    hdr=(MergeHeader)msg.RemoveHeader();
	    
	    switch(hdr.type) {

	    case MergeHeader.HELLO:          // if coord: handle, else: discard
		if(!is_server) {
		    return;
		}
		sender=(Address)msg.GetSrc();
		if(sender != null) {
		    synchronized(members) {
			contains=members.contains(sender);
		    }
		    if(!contains) {


			System.out.println("MERGE.Up(): membership " + members + " does not contain " +
					   sender + "; merging it");
			tmp=new Vector();
			tmp.addElement(sender);
			PassUp(new Event(Event.MERGE, tmp));
			

		    }
		}
		return;

	    default:
		System.err.println("MERGE.Up(): got MERGE header with unknown type (" + hdr.type + ")");
		return;
	    }
	    

	case Event.SET_LOCAL_ADDRESS:
	    local_addr=(Address)evt.GetArg();
	    PassUp(evt);
	    break;

	default:
	    PassUp(evt);            // Pass up to the layer above us
	    break;
	}
    }





    public void Down(Event evt) {
	Message      msg;
	MergeHeader   hdr;
	long         time_to_wait, start_time;
	Vector       gossip_rsps=new Vector();

	switch(evt.GetType()) {

	case Event.STOP:
	    PassDown(evt);
	    if(gossip != null)
		gossip.Stop();
	    break;

	case Event.TMP_VIEW:

	case Event.VIEW_CHANGE:	    
	    Vector tmp;
	    if((tmp=(Vector)((View)evt.GetArg()).GetMembers()) != null) {
		synchronized(members) {
		    members.removeAllElements();
		    for(int i=0; i < tmp.size(); i++)
			members.addElement(tmp.elementAt(i));
		}
	    }
	    PassDown(evt);
	    break;

	case Event.BECOME_SERVER: // called after client has join and is fully working group member
	    PassDown(evt);
	    if(gossip != null)
		gossip.Start();
	    Start();
	    is_server=true;
	    break;

	case Event.CONNECT:
	    group_addr=(String)evt.GetArg();
	    PassDown(evt);
	    break;

	case Event.DISCONNECT:
	    if(local_addr != null && evt.GetArg() != null && local_addr.equals(evt.GetArg()))
		Stop();
	    if(gossip != null)
		gossip.Stop();
	    PassDown(evt);
	    break;
	    
	default:
	    PassDown(evt);          // Pass on to the layer below us
	    break;
	}
    }




    /**
       If IP multicast: periodically mcast a HELLO message
       If gossiping: periodically retrieve the membership. Any members not part of our 
       own membership are merged (passing MERGE event up).
     */
    public void run() {
	Message      hello_msg;
	MergeHeader   hdr;
	Vector       rsps, members_to_merge=new Vector();
	Object       mbr;


	try {Thread.currentThread().sleep(3000);} /// initial sleep; no premature merging
	catch(Exception e) {}
	    

	while(true) {
	    Util.Sleep(timeout);

	    if(gossip == null) {                              // plain IP MCAST
		hello_msg=new Message(null, null, null);
		hdr=new MergeHeader(MergeHeader.HELLO);
		hello_msg.AddHeader(hdr);
		PassDown(new Event(Event.MSG, hello_msg));
	    }
	    else {                                       // gossiping; contact Gossip server
		rsps=gossip.Get(group_addr);


		synchronized(members) {
		    members_to_merge.removeAllElements();
		    
		    for(int i=0; i < rsps.size(); i++) {
			mbr=rsps.elementAt(i);
			if(!members.contains(mbr)) {
			    
			    System.out.println("MERGE.run(): membership " + members + 
			    		       " does not contain " + mbr + "; merging it");
			    
			    
			    members_to_merge.addElement(mbr);
			}
		    }
		    
		    if(members_to_merge.size() > 0)
			PassUp(new Event(Event.MERGE, members_to_merge));
		}
				
	    }
	}
    }






    /* -------------------------- Private methods ---------------------------- */

    void Start() {
	if(hello_thread == null) {
	    hello_thread=new Thread(this, "MERGE Thread");
	    hello_thread.start();
	}
    }

    
    void Stop() {
	if(hello_thread != null) {
	    hello_thread.stop();
	    hello_thread=null;
	}
    }


//      private void StartGossip() {
//  	if(gossip == null) {
//  	    gossip=new GossipClient((String)group_addr, gossip_host, gossip_port);
//  	    if(local_addr != null)
//  		gossip.Register(local_addr);
//  	    else
//  		System.err.println("MERGE.StartGossip(): starting gossip client, but local " +
//  				   "address is null !");
//  	    gossip.Start();
//  	}
//      }



//      private void StopGossip() {
//  	if(gossip != null) {
//  	    gossip.Stop();
//  	    gossip=null;
//  	}
//      }




}
