package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



/**
 * Example of a protocol layer. Contains no real functionality, can be used as a template.
 */

public class LOSS extends Protocol {
    boolean   trace=false;
    Vector    members=new Vector();
    long      i=0;
    boolean   drop_next_msg=false;

    /** All protocol names have to be unique ! */
    public String  GetName() {return "LOSS";}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}
	if(props.size() > 0) {
	    System.err.println("LOSS.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }


    /** Just remove if you don't need to reset any state */
    public void Reset() {}




//      public void Up(Event evt) {
//  	Message msg;

//  	switch(evt.GetType()) {

//  	case Event.START:
//  	    // Start work
//  	    break;

//  	case Event.MSG:
//  	    msg=(Message)evt.GetArg();
//  	    if(msg.GetDest() != null && !((Address)msg.GetDest()).IsMulticastAddress()) {
//  		// System.err.println("LOSS.Up(): not dropping msg as it is unicast !");
//  		break;
//  	    }

//  	    i++;

//  	    int r=((int)(Math.random() * 1000)) % 10;

//  	    if(r != 0 && i % r == 0) { // drop
//  		System.out.println("####### LOSS.Up(): dropping message " + 
//  				   Util.PrintEvent(evt));
//  		return;
//  	    }

//  	    break;
//  	}

//  	PassUp(evt);            // Pass up to the layer above us
//      }





    public void Down(Event evt) {
	Message msg;
	
	switch(evt.GetType()) {

	case Event.TMP_VIEW:
	case Event.VIEW_CHANGE:
	    Vector new_members=(Vector)((View)evt.GetArg()).GetMembers();
	    synchronized(members) {
		members.removeAllElements();
		if(new_members != null && new_members.size() > 0)
		    for(int i=0; i < new_members.size(); i++)
			members.addElement(new_members.elementAt(i));
	    }
	    PassDown(evt);
	    break;

	case Event.MSG:
	    if(drop_next_msg) {
		drop_next_msg=false;
		msg=(Message)evt.GetArg();

		if(msg.GetDest() != null && !((Address)msg.GetDest()).IsMulticastAddress()) {
		    break;
		}

		if(trace) 
		    System.out.println("###### LOSS.Down(): dropping msg " + Util.PrintMessage(msg));
		
		return;
	    }
	    break;

	case Event.DROP_NEXT_MSG:
	    drop_next_msg=true;
	    break;
	}



	PassDown(evt);          // Pass on to the layer below us
    }



}
