package JavaGroups.JavaStack.Protocols;

import java.util.Vector;
import java.util.Properties;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

/**
 * Example of a protocol layer. Contains no real functionality, can be used as a template.
 */

public class HDRS extends Protocol {
    public String  GetName() {return "HDRS";}


    private void PrintMessage(Message msg, String label) {
	System.out.println("------------------------- " + label + " ----------------------");
	System.out.println(msg);
	msg.PrintObjectHeaders();
	System.out.println("--------------------------------------------------------------");
    }


    public void Up(Event evt) {

 	if(evt.GetType() == Event.MSG) {
 	    Message msg=(Message)evt.GetArg();
 	    PrintMessage(msg, "up");
 	}

	PassUp(evt); // Pass up to the layer above us
    }



    public void Down(Event evt) {

 	if(evt.GetType() == Event.MSG) {
 	    Message msg=(Message)evt.GetArg();
 	    PrintMessage(msg, "down");
	}

	PassDown(evt);  // Pass on to the layer below us
    }


}
