package JavaGroups.JavaStack.Protocols;


import java.util.*;
import java.awt.*;
import java.awt.List;
import java.awt.event.*;
import JavaGroups.*;
import JavaGroups.Event;
import JavaGroups.JavaStack.*;





class MyFrame extends Frame {
    List        list=new List();
    Label       result=new Label("Result:          ");
    Button      send=new Button("Send Request"), quit=new Button("Quit");
    Panel       button_panel=new Panel();
    Panel       main_panel=new Panel();
    DEADLOCK    deadlock=null;
    Vector      members=null;
    
    
    MyFrame(String title, DEADLOCK deadlock) {
	this.deadlock=deadlock;
	setSize(300, 200);
	setTitle(title);
	setBackground(Color.white);
	setFont(new Font("Helvetica", Font.PLAIN, 12));
	setLayout(new BorderLayout());
	main_panel.setLayout(new GridLayout(0, 2));
	main_panel.add(result);
	main_panel.add(list);
	button_panel.add(send);
	button_panel.add(quit);
	add("Center", main_panel);
	add("South", button_panel);
	AddEventHandlers();
    }


    void AddEventHandlers() {

	quit.addActionListener(
			       new ActionListener() {
	    public void actionPerformed(ActionEvent e) {dispose();}
	});

	send.addActionListener(
			       new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		Object dest;
		int    res;
		int    index=-1;
		
		index=list.getSelectedIndex();
		if(index == -1)
		    return;
		dest=members != null ? members.elementAt(index) : null;
		if(dest != null) {
		    res=deadlock.SendRequest(dest);
		    SetResult(res);
		}
	    }
	});

	
    }


    void SetResult(int res) {
	result.setText("Result: " + res);
    }

    void SetMembers(Vector members) {
	list.removeAll();
	for(int i=0; i < members.size(); i++)
	    list.add(members.elementAt(i).toString());
	this.members=members;
    }

}





/**
   Tests the deadlock detection mechanism of RequestCorrelator.
 */
public class DEADLOCK extends RpcProtocol {
    Vector   members=new Vector();
    boolean  trace=false;
    MyFrame  frame=null;
    



    public String  GetName() {return "DEADLOCK";}


    public int SendRequest(Object dest) {
	Object retval;
	
	try {
	    System.out.println("--> GetCombinedResults() to " + dest);
	    retval=CallRemoteMethod(dest, "GetCombinedResults", GroupRequest.GET_FIRST, 0);
	}
	catch(Exception e) {
	    return -1;
	}
	if(retval != null && retval instanceof Integer)
	    return ((Integer)retval).intValue();
	return -1;
    }


    /* ------------------------- Request handler methods ----------------------------- */


    /** Mcasts GetResult() to all members (including itself). Returns the sum of all results. */
    public int GetCombinedResults() {
	RspList  rsp_list;
	Vector   results;
	int      retval=0;

	System.out.println("<-- GetCombinedResults()");

	System.out.println("--> GetResult() to " + members);
	rsp_list=CallRemoteMethods(members, "GetResult", GroupRequest.GET_ALL, 0);
	results=rsp_list.GetResults();
	for(int i=0; i < results.size(); i++)
	    retval+=((Integer)results.elementAt(i)).intValue();
	return retval;
    }


    /** Returns a random integer value between 1 and 10 */
    public int GetResult() {

	System.out.println("<-- GetResult()");

	return (int)((Math.random() * 10) % 10) + 1;
    }


    /* --------------------- End of Request handler methods -------------------------- */




    
    /**
       <b>Callback</b>. Called by superclass when event may be handled.<p>
       <b>Do not use <code>PassUp</code> in this method as the event is passed up
       by default by the superclass after this method returns !</b>
       @return boolean Defaults to true. If false, event will not be passed up the stack.
     */
    public boolean HandleUpEvent(Event evt) {
	switch(evt.GetType()) {

	case Event.START:
	    if(_corr != null)
		_corr.SetDeadlockDetection(true);
	    else
		System.err.println("Cannot set deadlock detection in corr, as it is null !");
	    frame=new MyFrame(GetName(), this);
	    frame.show();
	    break;

	case Event.TMP_VIEW:
	case Event.VIEW_CHANGE:
	    Vector new_members=(Vector)((View)evt.GetArg()).GetMembers();
	    synchronized(members) {
		members.removeAllElements();
		if(new_members != null && new_members.size() > 0)
		    for(int i=0; i < new_members.size(); i++)
			members.addElement(new_members.elementAt(i));
	    }
	    frame.SetMembers(members);
	    break;

	case Event.STOP:
	    if(frame != null) {
		frame.dispose();
		frame=null;
	    }
	    break;

	case Event.SET_LOCAL_ADDRESS:
	    frame.setTitle(frame.getTitle() + ": " + evt.GetArg().toString());
	    break;
	    
	}

	return true;
    }


    /**
       <b>Callback</b>. Called by superclass when event may be handled.<p>
       <b>Do not use <code>PassDown</code> in this method as the event is passed down
       by default by the superclass after this method returns !</b>
       @return boolean Defaults to true. If false, event will not be passed down the stack.
    */
    public boolean HandleDownEvent(Event evt) {
	switch(evt.GetType()) {
	case Event.TMP_VIEW:
	case Event.VIEW_CHANGE:
	    Vector new_members=(Vector)((View)evt.GetArg()).GetMembers();
	    synchronized(members) {
		members.removeAllElements();
		if(new_members != null && new_members.size() > 0)
		    for(int i=0; i < new_members.size(); i++)
			members.addElement(new_members.elementAt(i));
	    }
	    System.out.println("Setting members");
	    frame.SetMembers(members);
	    System.out.println("done");
	    break;
	case Event.STOP:
	    if(frame != null) {
		frame.dispose();
		frame=null;
	    }
	    break;
	}
	return true;
    }


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}
	if(props.size() > 0) {
	    System.err.println("DEADLOCK.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }



}
