package JavaGroups.Demos.wb;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import JavaGroups.*;





class ApplFrame extends Frame implements WindowListener, ComponentListener {
    Whiteboard wb=null;

    public ApplFrame(String title, Whiteboard wb) {
	super(title);
	this.wb=wb;
	add(wb);
	setSize(299, 299);
	setVisible(true);
	wb.init();
	setSize(300, 300);
	addWindowListener(this);
	addComponentListener(this);
    }



    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
	dispose();
	System.exit(0);
    }

    public void windowClosed(WindowEvent e)      {}
    public void windowIconified(WindowEvent e)   {}
    public void windowDeiconified(WindowEvent e) {
	wb.repaint();
    }
    public void windowActivated(WindowEvent e)   {
	wb.repaint();
    }
    public void windowDeactivated(WindowEvent e) {}

    public void componentResized(ComponentEvent e) {
	wb.repaint();
    }

    public void componentMoved(ComponentEvent e) {}


    public void componentShown(ComponentEvent e) {}

    public void componentHidden(ComponentEvent e) {}


}









public class Whiteboard extends Applet implements ActionListener, MessageListener, MembershipListener,
						  ComponentListener, FocusListener {




    public RpcDispatcher           disp;
    Channel                        channel;
    GraphPanel                     panel;
    private Button                 clear_button, leave_button;
    private Label                  mbr_label;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private String                 props=null;
    public final String            groupname="WbGrp";
    private boolean                application=false;


    public void    Receive(Message m)          {}
    public Object  GetState()                  {panel.SaveState(); return panel.GetState();}
    public void    SetState(Object new_state)  {panel.SetState(new_state);}



    private String GetInfo() {
	StringBuffer ret=new StringBuffer();
	ret.append(" (" + System.getProperty("os.name") + " " + System.getProperty("os.version") +
		   " " + System.getProperty("os.arch") + ")");
	return ret.toString();
    }

    private Frame FindParent() {
	Component retval=getParent();

	while(retval != null) {
	    if(retval instanceof Frame)
		return (Frame)retval;
	    retval=retval.getParent();
	}
	return null;
    }

    
    public Whiteboard() {	// needed when started as applet
    }

    public Whiteboard(String properties) {
	application=true;
	props=properties;

    }


    public void init() {
	setLayout(new BorderLayout());
	panel = new GraphPanel(this);
	panel.setBackground(Color.white);
	add("Center", panel);
	Panel p = new Panel();

	leave_button=new Button("Exit");
	leave_button.setFont(default_font);
	leave_button.addActionListener(this);
	mbr_label=new Label("1 mbr(s)");
	mbr_label.setFont(default_font);
	p.add("South", leave_button);
	p.add("South", mbr_label);
	add("South", p);

	if(!application)
	    props=getParameter("properties");
	if(props == null)
	    //props="TUNNEL(router_host=janet;router_port=12002):" + 
	    //"GMS(gossip_host=janet;gossip_port=12001;sleep_time=500;sleep_num=2)";

	    props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:STATE_TRANSFER:QUEUE";

	try {
	    channel=new JChannel(props);
	    disp=new RpcDispatcher(channel, this, this, this);
	    channel.Connect(groupname);
	    channel.GetState(null, 0);
	}
	catch(Exception e) {
	    System.err.println("Whiteboard.init(): " + e);
	}
	panel.my_addr=channel.GetLocalAddress();


	UserInfoDialog dlg=new UserInfoDialog(FindParent());
	String n=dlg.GetUserName();
	String info=GetInfo();
	panel.Start(n + info);
	

	addComponentListener(this);
	addFocusListener(this);
    }


    public void destroy() {
	if(disp != null) {
	    try {
		disp.CallRemoteMethods(null, "RemoveNode", panel.my_addr, GroupRequest.GET_ALL, 0);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	    channel.Close();
	    disp=null;
	    if(panel != null) {
		panel.Stop();
		panel=null;
	    }
	}

    }


    public void repaint() {
	if(panel != null)
	    panel.repaint();
    }


    public void actionPerformed(ActionEvent e) {
	String  command=e.getActionCommand();

	if(command.equals("Exit")) {
	    try {
		setVisible(false);
		destroy();
		if(application) {
		    ((Frame)getParent()).dispose();
		    System.exit(0);
		}
	    }
	    catch(Exception ex) {
		System.err.println(ex);
	    }

	}
	else
	    System.out.println("Unknown action");
    }



    public void ViewAccepted(View v) {
	if(v != null) {
	    if(mbr_label != null)
		mbr_label.setText(v.Size() + " mbr(s)");
	}
	panel.AdjustNodes(v.GetMembers());
    }

    public void Suspect(Object obj) {}

    public void Block() {}



    public void MoveNode(Node n) {
	panel.MoveNode(n);
    }

    
    public void AddNode(String lbl, Object addr, int xloc, int yloc) {
	panel.AddNode(lbl, addr, xloc, yloc);
    }


    public void RemoveNode(Object addr) {
	panel.RemoveNode(addr);
    }



    public void DisplayMessage(String sender, String msg) {
	MessageDialog d=new MessageDialog(FindParent(), sender, msg);
	panel.repaint();
    }



    public void componentResized(ComponentEvent e) {
	if(panel != null) panel.repaint();
    }
    public void componentMoved(ComponentEvent e)   {
    }
    public void componentShown(ComponentEvent e)   {
	if(panel != null) panel.repaint();
    }
    public void componentHidden(ComponentEvent e)  {
    }



    public void focusGained(FocusEvent e) {
	if(panel != null) panel.repaint();
    }


    public void focusLost(FocusEvent e) {
    }






    public static void main(String[] args) {
 	Whiteboard wb=new Whiteboard(null);
 	ApplFrame  f=new ApplFrame("Whiteboard Application", wb);       
    }


}
