
import java.io.*;
import java.util.*;
import JavaGroups.*;


public class RpcDispatcherTest {
    Channel            channel;
    RpcDispatcher      disp;
    RspList            rsp_list;
    String             props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE";
    


    public int Print(int number) {
	System.out.println("Print(" + number + ")");
	return number * 2;
    }


    public void Start() throws Exception {
	channel=new JChannel(props);
	disp=new RpcDispatcher(channel, null, null, this);
	channel.Connect("RpcDispatcherTestGroup");

	for(int i=0; i < 100; i++) {
	    Util.Sleep(1000);
	    rsp_list=disp.CallRemoteMethods(null, "Print", new Integer(i), GroupRequest.GET_ALL, 0);
	    System.out.println("Responses: " +rsp_list);
	}
	channel.Close();
	disp.Stop();
    }





    public static void main(String[] args) {
	try {
	    new RpcDispatcherTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
