
import java.util.*;
import JavaGroups.*;



/**
 * Example of a replicated quote server using JavaGroups and Ensemble (ejava). The server
 * maintains state which consists of a list of quotes and their corresponding values. When it
 * is started, it tries to reach other quote servers to get its initial state. If it does not
 * receive any response after 5 seconds, it assumes it is the first server and starts
 * processing requests. When it receives a view notification it checks whether there are more 
 * members in the view than in its previous view. If this is the case, it broadcasts a 
 * request for the state to all members. Integration of different states is simply the union
 * of all states (with the danger of overwriting mutually inconsistent state).<p>
 * This mechanism allows both for fast discovery of initial servers, and - in the case of
 * partition merging - for reintegration of existing servers. Broadcasting the state request
 * upon every view change (only when new members are joined) causes potentially a lot of 
 * network traffic, but it is assumes that there will not be more than 5 quote servers at most.
 */

public class QuoteServer implements MembershipListener, MessageListener {
    Hashtable       stocks=new Hashtable();
    Channel         channel;
    RpcDispatcher   disp;
    final String    channel_name="Quotes";
    int             num_members=1;
    String          props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:"+
	                  "VIEW_ENFORCER:STATE_TRANSFER:QUEUE";



    
    private void Integrate(Hashtable state) {	
	String key;
	if(state == null)
	    return;
	for(Enumeration e=state.keys(); e.hasMoreElements();) {
	    key=(String)e.nextElement();
	    stocks.put(key, state.get(key));  // just overwrite
	}
    }


    public void ViewAccepted(View new_view) {
	System.out.println("Accepted view (" + new_view.Size() + new_view.GetMembers() +
			   ")");
    }

    public void Suspect(Object suspected_mbr) {}
    
    public void Block() {}


    public void Start() {
	try {
	    channel=new JChannel(props);
	    channel.SetOpt(Channel.GET_STATE_EVENTS, new Boolean(true));
	    disp=new RpcDispatcher(channel, this, this, this);
	    channel.Connect(channel_name);
	}
	catch(Exception e) {
	    System.err.println("QuoteServer.Start() : " + e);
	    System.exit(-1);
	}

	System.out.println("\nQuote Server started at " + new Date());
	System.out.println("Joined channel '" + channel_name + "' (" + 
			   channel.GetView().Size() + " members)");
	channel.GetState(null, 0);
	System.out.println("Ready to serve requests");
    }


    /* Quote methods: */

    public float GetQuote(String stock_name) throws Exception {
	System.out.print("Getting quote for " + stock_name + ": ");
	Float retval=(Float)stocks.get(stock_name);
	if(retval == null) {
	    System.out.println("not found");
	    throw new Exception("Stock " + stock_name + " not found");
	}
	System.out.println(retval.floatValue());
	return retval.floatValue();
    }

    public void SetQuote(String stock_name, Float value) {
	System.out.println("Setting quote for " + stock_name + ": " + value);
	stocks.put(stock_name, value);
    }


    public Hashtable GetAllStocks() {
	System.out.print("GetAllStocks: ");
	PrintAllStocks();
	return stocks;
    }
    
    public void PrintAllStocks() {
	System.out.println(stocks);
    }



    public void Receive(Message msg) {}

    public Object GetState() {
	return stocks.clone();
    }

    public void SetState(Object state) {
	Integrate((Hashtable)state);
    }


    public static void main(String args[]) {
	QuoteServer server=new QuoteServer();
	server.Start();
    }

}
