import java.io.*;
import java.util.*;


import JavaGroups.*;


public class QueueTest {
    Queue   q=new Queue();
    Thread  producer, consumer;
    long    num=30000;


    class Consumer extends Thread {

	public void run() {
	    Object obj;
	    long   num_objects=0;

	    System.out.println("Consumer started");
	    for(long i=0; i < num; i++) {
		try {
		    obj=q.Remove();
		    num_objects++;
		    if(i > 0 && i % 1000 == 0)
			System.out.println("Consumer: " + i);
		}
		catch(QueueClosed e) {
		    System.err.println(e);
		    break;
		}
	    }
	    System.out.println("Consumer: removed " + num_objects + " objects");
	}

    }




    class Producer extends Thread {

	public void run() {
	    Object obj=new String("Bela Ban");
	    long   num_objects=0;

	    System.out.println("Producer started");
	    for(long i=0; i < num; i++) {
		try {
		    q.Add(obj);
		    num_objects++;
		    if(i > 0 && i % 1000 == 0)
			System.out.println("Producer: " + i);
		}
		catch(QueueClosed e) {
		    System.err.println(e);
		    break;
		}
	    }
	    System.out.println("Producer: added " + num_objects + " objects");
	}

    }





    public void Start() throws Exception {
	producer=new Producer();
	consumer=new Consumer();
	producer.start();
	consumer.start();

	consumer.join();
    }










    public static void main(String[] args) {
	try {
	    new QueueTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
