
import java.net.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



	    



public class NakReceiverWindowTest {

    static class QueueEntry {
	long   first_seqno=0, last_seqno=0;
	Object sender=null;
	
	public QueueEntry(long first_seqno, long last_seqno, Object sender) {
	    this.first_seqno=first_seqno; this.last_seqno=last_seqno; this.sender=sender;
	}
    }
    



    public static void main(String args[]) {
	
	

	class Retransmitter implements NakReceiverWindow.RetransmitCommand, Runnable {
	    NakReceiverWindow win=null;
	    Queue             queue=new Queue();

	    void SetWindow(NakReceiverWindow w) {win=w;}




	    public synchronized void Retransmit(long first_seqno, long last_seqno, Object sender) {
		try {
		    queue.Add(new QueueEntry(first_seqno, last_seqno, sender));
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	    
	    public void run() {
		QueueEntry entry;
		
		while(true) {
		    try {
			entry=(QueueEntry)queue.Remove();
		    }
		    catch(Exception e) {
			System.err.println(e);
			break;
		    }
		    System.out.println("RetransmitRequest: first_seqno=" + entry.first_seqno + 
				       ", last_seqno=" + entry.last_seqno + ", sender=" + entry.sender);
		    
		    Message m=new Message(null, null, null);
		    try {
			m.SetBuffer(Util.ObjectToByteBuffer(new Long(entry.first_seqno)));
		    }
		    catch(Exception e) {}
		    System.out.println("Adding " + entry.first_seqno + " as result of retransmission");
		    win.Add(entry.first_seqno, m);
		}
	    }
	    
	}


	class Remover extends Thread {
	    NakReceiverWindow w=null;
	    Remover(NakReceiverWindow w) {this.w=w; setName("RemoverThread");}

	    public void run() {
		Message m;
		
		while(true) {
		    try {
			System.out.println("Remover: trying to remove (size is " + w.Size() + ")");
			while((m=w.Remove()) != null) {
			    System.out.println("Removed #" + Util.ObjectFromByteBuffer(m.GetBuffer()));
			}
			sleep(100);
		    }
		    catch(Exception e) {
			System.err.println(e);
		    }
		}

	    }
	}


	class Adder extends Thread {
	    NakReceiverWindow w=null;
	    Adder(NakReceiverWindow w) {this.w=w; setName("AdderThread");}

	    public void run() {
		Message msg;

		for(int i=0; i < 1000; i++) {
		    try {
			if(i % 7 == 0 || i % 3 == 0)
			    //if(i % 17 == 0)
			    continue;
			msg=new Message();
			msg.SetBuffer(Util.ObjectToByteBuffer(new Integer(i)));
			System.out.println("Adding " + i);
			w.Add(i, msg);
			Thread.currentThread().yield();
		    }
		    catch(Exception e) {
			System.err.println(e);
		    }
		}		
	    }
	}





	NakReceiverWindow w;
	Message       msg=null;
	Address       sender=null;
	Retransmitter retransmitter=new Retransmitter();
	Thread        retr=new Thread(retransmitter);

	retr.start();

	try {
	    sender=new Address(InetAddress.getByName("janet"), 5555);
	}
	catch(Exception e) {
	    System.err.println(e);
	}

	w=new NakReceiverWindow(sender, retransmitter, 0);
	retransmitter.SetWindow(w);
	

	Thread remover=new Remover(w);
	remover.start();

	Thread adder=new Adder(w);
	adder.start();


	try {
	    System.out.println("Joining Adder:");
	    adder.join();
	    System.out.println("Joining Adder: DONE");
	    System.out.println("Joining Remover:");
	    remover.join(50000);
	    System.out.println("Joining Remover: DONE");
	    remover.stop();
	}
	catch(Exception e) {
	    System.err.println(e);
	}



    }
}
