
import java.io.*;
import java.net.*;
import java.util.*;





public class NakAckTestUdp {
    MulticastSocket socket;




class Sender extends Thread {
    MulticastSocket socket;
    InetAddress     address;
    int             port=0;
    int             num=0;

    public Sender(MulticastSocket socket, InetAddress address, int port) {
	this.socket=socket;
	this.address=address;
	this.port=port;
    }

    public void run() {
	DatagramPacket packet;
	byte[] buf;

	while(true) {
	    try {
		buf=JavaGroups.Util.ObjectToByteBuffer(new Integer(num++));
		packet=new DatagramPacket(buf, buf.length, address, port);
		socket.send(packet);
		sleep(1);
	    }
	    catch(Exception e) {
		System.err.println("Sender.run(): " + e);
	    }
	}
    }
}



class Receiver extends Thread {
    MulticastSocket socket;
    int             num=0;

    public Receiver(MulticastSocket socket) {this.socket=socket;}

    public void run() {
	Integer         i;
	DatagramPacket  packet;
	byte[]          buf=new byte[256];

	while(true) {
	    try {
		packet=new DatagramPacket(buf, buf.length);
		sleep(50);
		socket.receive(packet);
		i=(Integer)JavaGroups.Util.ObjectFromByteBuffer(packet.getData());

		if(i.intValue() != num) {
		    System.err.println("i received (" + i + "), but " + num + " expected !");
		    num=i.intValue()+1;
		    // Util.DumpStack(true);
		}
		else {
		    System.out.println(i + " == " + num);
		    num++;
		}

	    }
	    catch(Exception e) {
		System.err.println("Receiver.run(): " + e);
	    }
	}
    }
}


    

    public void Start() throws Exception {
	InetAddress group_addr=InetAddress.getByName("228.5.6.7");
	socket=new MulticastSocket(7500);
	socket.joinGroup(group_addr);
	new Receiver(socket).start();
	new Sender(socket, group_addr, 7500).start();
    }



    public static void main(String[] args) {
	try {
	    new NakAckTestUdp().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
