import java.io.*;
import java.util.*;


import JavaGroups.*;



public class NakAckTest {
    Channel channel;


    class MsgSender extends Thread {
	Channel channel;
	int     num=0;

	public MsgSender(Channel channel) {this.channel=channel;}

	public void run() {
	    for(int i=0; i < 50; i++) {
		try {

		    if(i == 30)
			((JChannel)channel).Down(new Event(Event.SWITCH_NAK_ACK));

		    if(i == 35)
			((JChannel)channel).Down(new Event(Event.SWITCH_NAK));
		    

		    channel.Send(new Message(null, null, new Integer(num++)));
		    sleep(50);
		}
		catch(ChannelNotConnected not_conn) {
		    break;
		}
		catch(ChannelClosed closed) {
		    break;
		}
		catch(Exception e) {
		    System.err.println("Sender.run(): " + e);
		}
	    }
	}
    }



    class MsgReceiver extends Thread {
	Channel channel;
	int     num=0;

	public MsgReceiver(Channel channel) {this.channel=channel;}

	public void run() {
	    Message msg;
	    Object  obj;
	    Integer i;

	    while(true) {
		try {
		    obj=channel.Receive(0);
		    if(obj == null || !(obj instanceof Message))
			continue;
		    msg=(Message)obj;
		    i=(Integer)Util.ObjectFromByteBuffer(msg.GetBuffer());

		    if(i.intValue() != num) {
			System.err.println("i received (" + i + "), but " + num + " expected !");
			num=i.intValue()+1;
			Util.DumpStack(true);
		    }
		    else {
			System.out.println(i + " == " + num);
			num++;
		    }

		    if(i.intValue() >= 49)
			return;

		}
		catch(ChannelNotConnected not_conn) {
		    break;
		}
		catch(ChannelClosed closed) {
		    break;
		}
		catch(Exception e) {
		    System.err.println("Receiver.run(): " + e);
		}
	    }
	}
    }


    

    public void Start() throws Exception {
	channel=new JChannel();
	channel.Connect("NakAckTestGroup");

	Thread receiver=new MsgReceiver(channel);
	Thread sender=new MsgSender(channel);

	receiver.start();
	sender.start();


	sender.join();
	System.out.println("Sender is done");
	receiver.join();
	System.out.println("Receiver is done");
	
	channel.Close();
    }



    public static void main(String[] args) {
	try {
	    new NakAckTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
