
import java.net.*;
import java.util.*;
import JavaGroups.*;

/**
 * We just return messages that come in by swapping the destination and source
 * addresses. At the Transport level, we don't care to which object a Message is sent
 * (as in the Dispatcher, where messages can only be sent to either single objects or to
 * groups). Rather we accept all messages and return them immediately. Similar to the
 * Internet Echo service, which just returns the packet received to the sender using
 * ICMP.
 */

public class EchoChannel {
    private Channel channel;
    private String  name="SyncCallTest";

    public EchoChannel(String n) {name=n;}
    public EchoChannel()         {}


    public void Start() {
	Object tmp;
	Message  msg, rsp;
	String   rsp_str;

	System.out.println("Creating channel for '" + name + "'");

	try {
	    channel=new JChannel(null);
	    channel.Connect(name);
	    System.out.println("Waiting for messages");
	    while((tmp=channel.Receive(0)) != null) {
		if(!(tmp instanceof Message))
		    continue;
		msg=(Message)tmp;
		System.out.println("Received message");
		rsp=msg.MakeReply();
		rsp_str=new String("Response to '" + new String(msg.GetBuffer()) + "'");
		rsp.SetBuffer(rsp_str.getBytes());
		System.out.println("Sending rsp: " + rsp);
		channel.Send(rsp);
	    }
	    channel.Disconnect();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

    

    public static void main(String args[]) {
	EchoChannel me;
	if(args.length == 1)
	    me=new EchoChannel(args[0]);
	else
	    me=new EchoChannel();
	me.Start();
    }

    
    
    
}
