
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.net.*;


import JavaGroups.*;
import JavaGroups.Event;
import JavaGroups.JavaStack.*;
import JavaGroups.JavaStack.Protocols.*;


public class DrawIpMcastX extends Protocol 
                          implements Runnable, MouseMotionListener, WindowListener, ActionListener {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private DataInputStream        instream;
    private Random                 random=new Random(System.currentTimeMillis());
    private Button                 clear_button, leave_button;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private int                    member_size=0;
    private int                    red=0, green=0, blue=0;
    private Color                  default_color=null;
    UDP                            udp_prot;
    Queue                          mq=new Queue();
    Vector                         mq2=new Vector();
    Thread                         receiver;

 
    public DrawIpMcastX() throws Exception {
	udp_prot=new UDP();
	udp_prot.StartUpHandler();
	udp_prot.StartDownHandler();
	udp_prot.SetUpProtocol(this);
	udp_prot.StartWork();
	udp_prot.Down(new Event(Event.CONNECT, "DrawIpMcastXGroup"));
	receiver=new Thread(this);
	receiver.setPriority(Thread.MAX_PRIORITY);
	receiver.start();
    }


    public void ReceiveUpEvent(Event evt) {
	if(evt.GetType() != Event.MSG)
	    return;
	try {

	    // ProcessMessage((Message)evt.GetArg());

	    mq.Add(evt.GetArg());

	    //mq2.addElement(evt.GetArg());
	}
	catch(Exception e) {}
    }


    public void run() {
 	int             my_x=10, my_y=10, r=0, g=0, b=0;
	boolean         fl=true;
	Message         m;

	while(true) {
	    try {
		m=(Message)mq.Remove();
		
//  		if(mq2.size() == 0) {
//  		    Util.Sleep(10);
//  		    continue;
//  		}
//  		m=(Message)mq2.elementAt(0);
//  		mq2.removeElementAt(0);

		ProcessMessage(m);
	    }
	    //catch(QueueClosed closed) {
	    //return;
	    //}
	    catch(Exception e) {
		System.err.println(e);
		continue;
	    }
	}
    }



    void ProcessMessage(Message m) throws Exception {
	int             my_x=10, my_y=10, r=0, g=0, b=0;
	boolean         fl=true;

	instream=new DataInputStream(new ByteArrayInputStream(m.GetBuffer()));
	r=instream.readInt();   // red
	if(r == -13) {
	    ClearPanel();
	    return;
	}
	g=instream.readInt();   // green
	b=instream.readInt();   // blue
	my_x=instream.readInt();
	my_y=instream.readInt();
	
	if(graphics != null) {
	    graphics.setColor(new Color(r, g, b));
	    graphics.fillOval(my_x, my_y, 10, 10);
	    graphics.setColor(default_color);
	}
    }




    public String GetName() {
	return "DrawIpMcastX -- Dummy Protocol";
    }






    public static void main(String[] args) {
	DrawIpMcastX      draw=null;
	String           arg, next_arg;
	String           logfile=null;
	String           props=null;
    
	try {
	    draw=new DrawIpMcastX();
	    draw.go();
	}
	catch(Exception e) {
	    System.err.println(e);
	    System.exit(0);
	}
    }




    private void SelectColor() {
	red=(Math.abs(random.nextInt()) % 255);
	green=(Math.abs(random.nextInt()) % 255);
	blue=(Math.abs(random.nextInt()) % 255);
	default_color=new Color(red, green, blue);
    }


	
    public void go() {
	try {

	    mainFrame=new Frame();
	    panel=new Panel();
	    sub_panel=new Panel();
	    mainFrame.setSize(200,200);
	    mainFrame.add("Center", panel);
	    clear_button=new Button("Clear");
	    clear_button.setFont(default_font);
	    clear_button.addActionListener(this);
	    leave_button=new Button("Leave & Exit");
	    leave_button.setFont(default_font);
	    leave_button.addActionListener(this);
	    sub_panel.add("South", clear_button);
	    sub_panel.add("South", leave_button);
	    mainFrame.add("South", sub_panel);
	    mainFrame.addWindowListener(this);
	    panel.addMouseMotionListener(this);
	    mainFrame.setVisible(true);
	    mainFrame.setTitle(member_size + " mbrs");
	    graphics=panel.getGraphics();
	    SelectColor();
	    graphics.setColor(default_color);
	    mainFrame.setBackground(Color.white);
	    clear_button.setForeground(Color.blue);
	    leave_button.setForeground(Color.blue);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }


    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {
	int             x=e.getX(), y=e.getY();
	DatagramPacket  packet;
	byte[]          buf;
	Message         msg;


	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(red);
	    outstream.writeInt(green);
	    outstream.writeInt(blue);
	    outstream.writeInt(x);
	    outstream.writeInt(y);
	    msg=new Message(null, null, out.toByteArray());
	    udp_prot.Down(new Event(Event.MSG, msg));
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }


    public void ClearPanel() {
	Rectangle  bounds=null;
	if(panel == null || graphics == null)
	    return;

	bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }


    public void SendClearPanelMsg() {
	int             tmp[]=new int[1]; tmp[0]=0;
	DatagramPacket  packet;
	byte[]          buf;
	Message         m;

	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(-13);
	    m=new Message(null, null, out.toByteArray());
	    udp_prot.Down(new Event(Event.MSG, m));
	    outstream.flush();
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }




    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);  // exit the dirty way ...
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	String     command=e.getActionCommand();	
	if(command == "Clear")
	    SendClearPanelMsg();
	else if(command == "Leave & Exit") {
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }




}

