
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.net.*;




public class DrawIpMcast implements Runnable, MouseMotionListener, WindowListener, 
				    ActionListener {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private DataInputStream        instream;
    private Random                 random=new Random(System.currentTimeMillis());
    private Button                 clear_button, leave_button;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private MulticastSocket        mcast_sock=null;
    private InetAddress            mcast_group=null;
    private Thread                 receiver=null;
    private int                    member_size=0;
    private int                    red=0, green=0, blue=0;
    private Color                  default_color=null;

 
    public DrawIpMcast() throws Exception {
	mcast_sock=new MulticastSocket(5555);
	mcast_group=InetAddress.getByName("228.8.8.8");

	System.out.println("Mcast socket created -- local address is " + mcast_sock.getLocalAddress() +
			   ", local port is " + mcast_sock.getLocalPort());
    }


    public static void main(String[] args) {
	DrawIpMcast      draw=null;
	String           arg, next_arg;
	String           logfile=null;
	String           props=null;
    
	try {
	    draw=new DrawIpMcast();
	    draw.go();
	}
	catch(Exception e) {
	    System.err.println(e);
	    System.exit(0);
	}
    }




    private void SelectColor() {
	red=(Math.abs(random.nextInt()) % 255);
	green=(Math.abs(random.nextInt()) % 255);
	blue=(Math.abs(random.nextInt()) % 255);
	default_color=new Color(red, green, blue);
    }


	
    public void go() {
	try {
	    mcast_sock.joinGroup(mcast_group);

	    receiver=new Thread(this, "DrawThread");
	    receiver.start();
	    mainFrame=new Frame();
	    panel=new Panel();
	    sub_panel=new Panel();
	    mainFrame.setSize(200,200);
	    mainFrame.add("Center", panel);
	    clear_button=new Button("Clear");
	    clear_button.setFont(default_font);
	    clear_button.addActionListener(this);
	    leave_button=new Button("Leave & Exit");
	    leave_button.setFont(default_font);
	    leave_button.addActionListener(this);
	    sub_panel.add("South", clear_button);
	    sub_panel.add("South", leave_button);
	    mainFrame.add("South", sub_panel);
	    mainFrame.addWindowListener(this);
	    panel.addMouseMotionListener(this);
	    mainFrame.setVisible(true);
	    mainFrame.setTitle(member_size + " mbrs");
	    graphics=panel.getGraphics();
	    SelectColor();
	    graphics.setColor(default_color);
	    mainFrame.setBackground(Color.white);
	    clear_button.setForeground(Color.blue);
	    leave_button.setForeground(Color.blue);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }


    public void run() {
 	int             my_x=10, my_y=10, r=0, g=0, b=0;
	DatagramPacket  packet;
	boolean         fl=true;
	byte[]          buf=new byte[256];

	while(fl) {
	    my_x=10; 
	    my_y=10;
	    try {
		packet=new DatagramPacket(buf, buf.length);
		mcast_sock.receive(packet);
		instream=new DataInputStream(new ByteArrayInputStream(buf));
		r=instream.readInt();   // red
		if(r == -13) {
		    ClearPanel();
		    continue;
		}
		g=instream.readInt();   // green
		b=instream.readInt();   // blue
		my_x=instream.readInt();
		my_y=instream.readInt();
	    }
	    catch(Exception e) {
		System.err.println(e);
		break;
	    }
	    if(graphics != null) {
		graphics.setColor(new Color(r, g, b));
		graphics.fillOval(my_x, my_y, 10, 10);
		graphics.setColor(default_color);
	    }
	}
    }


    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {
	int             x=e.getX(), y=e.getY();
	DatagramPacket  packet;
	byte[]          buf;


	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(red);
	    outstream.writeInt(green);
	    outstream.writeInt(blue);
	    outstream.writeInt(x);
	    outstream.writeInt(y);
	    buf=out.toByteArray();
	    packet=new DatagramPacket(buf, buf.length, mcast_group, 5555);
	    mcast_sock.send(packet);
	    out.reset();	
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }


    public void ClearPanel() {
	Rectangle  bounds=null;
	if(panel == null || graphics == null)
	    return;

	bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }


    public void SendClearPanelMsg() {
	int             tmp[]=new int[1]; tmp[0]=0;
	DatagramPacket  packet;
	byte[]          buf;

	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(-13);
	    buf=out.toByteArray();
	    packet=new DatagramPacket(buf, buf.length, mcast_group, 5555);
	    mcast_sock.send(packet);
	    outstream.flush();
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }




    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);  // exit the dirty way ...
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	String     command=e.getActionCommand();	
	if(command == "Clear")
	    SendClearPanelMsg();
	else if(command == "Leave & Exit") {
	    try {
		mcast_sock.leaveGroup(mcast_group);
	    }
	    catch(Exception ex) {
		System.err.println(ex);
	    }
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }




}

