
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;


import JavaGroups.*;
import JavaGroups.Event;





/**
   Example that uses 2 channels: an unreliable data channel one which is used to
   broadcast mouse movements to all canvases, and a reliable control channel, which is
   used to install views etc.  */
public class Draw2Channels implements MouseMotionListener, WindowListener, ActionListener {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private DataInputStream        instream;
    private Random                 random=new Random(System.currentTimeMillis());
    private Button                 clear_button, leave_button;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private String                 control_groupname="Draw2ChannelsGroup-Control";
    private String                 data_groupname="Draw2ChannelsGroup-Data";
    private Channel                control_channel=null;
    private Channel                data_channel=null;
    private Thread                 control_receiver=null;
    private Thread                 data_receiver=null;
    private int                    member_size=0;
    private int                    red=0, green=0, blue=0;
    private Color                  default_color=null;




    class ControlReceiver extends Thread {
	public void run() {
	    Object    tmp;
	    Message   msg=null;

	    while(true) {
		try {
		    tmp=control_channel.Receive(0);
		
		    if(tmp == null) continue;
		
		    if(tmp instanceof View) {
			View v=(View)tmp;

			data_channel.Down(new Event(Event.VIEW_CHANGE, v));

			member_size=v.Size();
			if(mainFrame != null)
			    mainFrame.setTitle(member_size + " mbrs");
			continue;
		    }
		}
		catch(ChannelNotConnected not) {
		    break;
		}
		catch(ChannelClosed closed) {
		    return;
		}
		catch(Exception e) {
		    System.err.println(e);
		    break;
		}
	    }	    
	}
	
    }


    class DataReceiver extends Thread {

	public void run() {
	    Object    tmp;
	    Message   msg=null;
	    int       my_x=10, my_y=10, r=0, g=0, b=0;

	    while(true) {
		my_x=10; 
		my_y=10;
		try {
		    tmp=data_channel.Receive(0);
		
		    if(tmp == null || !(tmp instanceof Message))
			continue;

		    msg=(Message)tmp;
		    instream=new DataInputStream(new ByteArrayInputStream(msg.GetBuffer()));
		    r=instream.readInt();   // red
		    if(r == -13) {
			ClearPanel();
			continue;
		    }
		    g=instream.readInt();   // green
		    b=instream.readInt();   // blue
		    my_x=instream.readInt();
		    my_y=instream.readInt();
		}
		catch(ChannelNotConnected not) {
		    break;
		}
		catch(ChannelClosed closed) {
		    return;
		}
		catch(Exception e) {
		    System.err.println(e);
		    break;
		}
		if(graphics != null) {
		    graphics.setColor(new Color(r, g, b));
		    graphics.fillOval(my_x, my_y, 10, 10);
		    graphics.setColor(default_color);
		}
	    }	    
	}

    }


 
    public Draw2Channels(String control_props, String data_props) throws Exception {
	control_channel=new JChannel(control_props);
	data_channel=new JChannel(data_props);
	data_channel.SetOpt(Channel.VIEW, new Boolean(false));
    }


    public static void main(String[] args) {
	Draw2Channels    draw=null;
	ChannelFactory   factory=new JChannelFactory();
	String           arg, next_arg;
	String           logfile=null;
	String           control_props=null, data_props=null;
    

	try {


	    control_props="UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE";
	    data_props="UDP:FRAG";
	    
	    
	    for(int i=0; i < args.length; i++) {
		arg=args[i];
		if(arg.equals("-type")) {
		    next_arg=args[++i];
		}
		else if(arg.equals("-help")) {
		    System.out.println("Draw2Channels [-type ens | ibus ]");
		    return;
		}
	    }


	}
	catch(Exception e) {
	    System.out.println("Creation of channel factory failed, reason is: " + e);
	    return;
	}
	try {
	    draw=new Draw2Channels(control_props, data_props);
	    draw.go();
	}
	catch(Exception e) {
	    System.err.println(e);
	    System.exit(0);
	}
    }




    private void SelectColor() {
	red=(Math.abs(random.nextInt()) % 255);
	green=(Math.abs(random.nextInt()) % 255);
	blue=(Math.abs(random.nextInt()) % 255);
	default_color=new Color(red, green, blue);
    }


	
    public void go() {
	try {

	    System.out.println("Setting up control channel");
	    control_channel.Connect(control_groupname);
	    System.out.println("Setting up data channel");
	    data_channel.Connect(data_groupname);

	    System.out.println("Starting control receiver thread");
	    control_receiver=new ControlReceiver();
	    control_receiver.start();

	    System.out.println("Starting data receiver thread");
	    data_receiver=new DataReceiver();
	    data_receiver.start();

	   

	    mainFrame=new Frame();
	    panel=new Panel();
	    sub_panel=new Panel();
	    mainFrame.setSize(200,200);
	    mainFrame.add("Center", panel);
	    clear_button=new Button("Clear");
	    clear_button.setFont(default_font);
	    clear_button.addActionListener(this);
	    leave_button=new Button("Leave & Exit");
	    leave_button.setFont(default_font);
	    leave_button.addActionListener(this);
	    sub_panel.add("South", clear_button);
	    sub_panel.add("South", leave_button);
	    mainFrame.add("South", sub_panel);
	    mainFrame.addWindowListener(this);
	    panel.addMouseMotionListener(this);
	    mainFrame.setVisible(true);
	    mainFrame.setTitle(member_size + " mbrs");
	    graphics=panel.getGraphics();
	    SelectColor();
	    graphics.setColor(default_color);
	    mainFrame.setBackground(Color.white);
	    clear_button.setForeground(Color.blue);
	    leave_button.setForeground(Color.blue);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }


    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {
	int x=e.getX(),	y=e.getY();

	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(red);
	    outstream.writeInt(green);
	    outstream.writeInt(blue);
	    outstream.writeInt(x);
	    outstream.writeInt(y);
	    
//  	    if(graphics != null) {
//  		graphics.setColor(new Color(red, green, blue));
//  		graphics.fillOval(x, y, 10, 10);
//  		graphics.setColor(default_color);
//  	    }
	    
	    data_channel.Send(new Message(null, null, out.toByteArray()));
	    Util.Sleep(20);
	    out.reset();	
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }


    public void ClearPanel() {
	Rectangle  bounds=null;
	if(panel == null || graphics == null)
	    return;

	bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }


    public void SendClearPanelMsg() {
	int      tmp[]=new int[1]; tmp[0]=0;

	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(-13);
	    data_channel.Send(new Message(null, null, out.toByteArray()));
	    outstream.flush();
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }




    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);  // exit the dirty way ...
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	String     command=e.getActionCommand();	
	if(command == "Clear")
	    SendClearPanelMsg();
	else if(command == "Leave & Exit") {
	    try {

		System.out.println("Disconnecting from control channel");
		control_channel.Disconnect();
		control_channel.Close();

		System.out.println("Disconnecting from data channel");
		data_channel.Close();

	    }
	    catch(Exception ex) {
		System.err.println(ex);
	    }
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }




}

