
import java.util.*;
import JavaGroups.*;

public class ChannelTest implements Runnable {
    private Channel channel=null;
    private Thread  mythread=null;


    public void Start() throws Exception {
        channel=new JChannel(null);
        channel.Connect("ExampleGroup");
        mythread=new Thread(this);
        mythread.start();
        for(int i=0; i < 50; i++) {
            System.out.println("Casting msg #" + i);
            channel.Send(new Message(null, null, new String("Msg #" + i).getBytes()));
            Thread.currentThread().sleep(1000);
        }
        channel.Disconnect();
        channel.Close();
        mythread.join(0);
    }


    public void run() {
        Object  obj;
        Message msg;
        while(true) {
            try {
                obj=channel.Receive(0); // no timeout
                if(obj instanceof View)
                    System.out.println("--> NEW VIEW: " + obj);
                else if(obj instanceof Message) {
                    msg=(Message)obj;
                    System.out.println("Received " + new String(msg.GetBuffer()));
                }
            }
            catch(ChannelNotConnected conn) {
                break;
            }
            catch(Exception e) {
                System.err.println(e);
            }
        }
    }



    


    public static void main(String args[]) {
        ChannelTest test;
        try {
            test=new ChannelTest();
            test.Start();
        }
        catch(Exception e) {
            System.err.println(e);
        }
    }
   
}
