
import java.util.*;
import java.lang.reflect.*;

public class MethodInvocation implements java.io.Serializable {
    private String method_name;
    private Vector formal_args=new Vector();
    private Vector args=new Vector();
    private Object retval=null;

    
    public MethodInvocation(String name) {
	method_name=name;
    }



    public void AddArg(Object arg) {
	formal_args.addElement(arg.getClass());
	args.addElement(arg);
    }

    public void AddArg(byte b) {
	formal_args.addElement(Byte.TYPE);
	args.addElement(new Byte(b));
    }

    public void AddArg(char c) {
	formal_args.addElement(Character.TYPE);
	args.addElement(new Character(c));
    }

    public void AddArg(boolean b) {
	formal_args.addElement(Boolean.TYPE);
	args.addElement(new Boolean(b));
    }

    public void AddArg(int i) {
	formal_args.addElement(Integer.TYPE);
	args.addElement(new Integer(i));
    }

    public void AddArg(long l) {
	formal_args.addElement(Long.TYPE);
	args.addElement(new Long(l));
    }




    public Object invoke(Object target) {
	Class   cl=target.getClass();
	Method  meth;
	Object  retval=null;
	Class   class_args[];
	Object  obj_args[];
	
	if(method_name == null) {
	    System.out.println("Method name is not provided");
	    return null;
	}

	try {
	    class_args=new Class[formal_args.size()];
	    for(int i=0; i < formal_args.size(); i++)
		class_args[i]=(Class)formal_args.elementAt(i);

	    try {
		meth=cl.getMethod(method_name, class_args);
	    }
	    catch(NoSuchMethodException no) {
		System.out.println("Found no method called " + method_name + " in class " +
				   cl.getName() + " with " + formal_args + " formal parameters");
		return null;
	    }
	    obj_args=new Object[args.size()];
	    for(int i=0; i < args.size(); i++)
		obj_args[i]=args.elementAt(i);

	    retval=meth.invoke(target, obj_args);
	    return retval;
	}
	catch(Exception e) {
	    System.err.println(e);
	}

	return retval;
    }


    public String toString() {
	StringBuffer ret=new StringBuffer();
	ret.append("MethodInvocation (name=" + method_name + ")");
	ret.append("Number of arguments: " + args.size());
	return ret.toString();
    }
}
