
import java.io.*;
import java.net.*;

public class GetHtml {


    public static void ReadHeader(InputStream in) throws Exception {
	int prev=0;
	int c=0;
	while(true) {
	    c=in.read();
	    if(c == -1)
		return;
	    System.out.print((char)c);
	    if(c == '\n') {
		if(prev == '\n')
		    break;
		else
		    prev=c;
	    }
	    else
		prev=0;
	}
    }

    public static void ReadBody(InputStream in) throws Exception {
	int              c;
	byte             output[];
	FileOutputStream out=new FileOutputStream("out.class");
	ByteArrayOutputStream o=new ByteArrayOutputStream();
	
	while(true) {
	    c=in.read();
	    if(c == -1)
		break;
	    System.out.print((int)c);
	    o.write(c);
	}


	output=o.toByteArray();
	System.out.println("Output size is " + output.length);
	out.write(output);

	out.close();
    }
    
    
    public static void Retrieve(String host, int port, String filename) {
	Socket        s;
	InputStream   in;
	OutputStream  out;
	int           c;
	String        tmp;

	try {
	    s=new Socket(host, port);
	    in=s.getInputStream();
	    out=s.getOutputStream();
	    tmp="GET " + filename + " HTTP/1.0\n\n";
	    System.out.println("Retrieving " + tmp + " from " + host);
	    out.write(tmp.getBytes());
	    out.flush();

	    ReadHeader(in);
	    //	    ReadBody(in);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

    public static void main(String args[]) {
	if(args.length != 3) {
	    System.out.println("GetHtml <host> <port> <filename>");
	    return;
	}
	Retrieve(args[0], new Integer(args[1]).intValue(), args[2]);
    }

}
