package JavaGroups.algorithms;

import java.util.*;
import JavaGroups.*;

/**
 * Funclet that implements state exchange between a new member of a group and an existing
 * member. The funclet has to be installed with tye new member and all existing members
 * (using <code>Dispatcher.AddFunclet</code>). State exchange is started calling method
 * <code>Start</code>.<p>
 * <b>Prerequisites</b>:
 * <ul>
 * <li> Needs virtual synchrony and total order: all views and the messages between view
 *      have to be delivered in the same sequence at all members
 * <li> Dispatcher
 * </ul>
 */
public class StateExchangeFunclet {
    public final int          CLIENT_ROLE=1;
    public final int          SERVER_ROLE=2;
    protected int             role=CLIENT_ROLE;
    protected StateExchange   user_code=null;
    protected Dispatcher      disp=null;
    protected String          channel_name=null, funclet_name=null;
    protected Object          my_addr=null;
    
    
    
    public StateExchangeFunclet(Dispatcher disp, String channel_name, String funclet_name,
				StateExchange user_code) {
	if(disp == null || user_code == null) {
	    System.err.println("StateExchangeFunclet: dispatcher or user code is null !");
	    return;
	}
	this.disp=disp;
	this.channel_name=channel_name;
	this.funclet_name=funclet_name;
	this.user_code=user_code;
	this.role=role;
	my_addr=disp.GetAddress(channel_name);
    }

    
    public void SetRole(int role) {this.role=role;}
    
    
    public void Start() {
	Vector   members, tmp;
	Object   coord;
	int      index=0, num_members=0, num_tries=0;
	Object   state=null;
	
	Util.Print("---> Funclet started");
	
	if(role != CLIENT_ROLE) 
	    return;
	
	try {
	    disp.SendGetN(channel_name, new MethodCall("SaveState", funclet_name, null), 0, 0);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	
	System.out.println("Getting initial state:");
	
	// If more than 1 member (that's me !), get state from the first member
	// Do it as long as there are members

	tmp=disp.GetMembers(channel_name);

	Util.Print("---> Dispatcher.GetMembers(): members are " + tmp);

	members=tmp != null ? (Vector)tmp.clone() : null;

	while(members != null && members.size() > 1) {
	    coord=members.elementAt(index % members.size());
	    if(coord.equals(my_addr)) {
		index=(index+1) % members.size();  // try next member
		continue;
	    }
	    try {
		state=disp.Send(channel_name, coord, 
				new MethodCall("GetState", funclet_name, null), false, 2000);
	    }
	    catch(TimeoutException tex) {
		members.removeElement(coord);
		continue;
	    }
	    catch(Exception e) {
		System.err.println(e);
		continue;
	    }
	    if(state == null)
		continue;
	    break;
	}
	
	if(state != null) {
	    System.out.println("Successfully got state (disp=" + disp + ")");
	    user_code.SetState(state);        
	}
	else
	    System.out.println("No state available");

	disp.ReleaseRequests(channel_name);
	role=SERVER_ROLE;
    }
    


    
    public void SaveState() {

	Util.Print("---> SaveState()");

	if(role == CLIENT_ROLE)
	    disp.HoldRequests(channel_name);
	else
	    user_code.SaveState();
    }



    public Object GetState() {
	if(role == SERVER_ROLE)
	    return user_code.GetState();
	return null;
    }
    
}
