
import java.net.*;
import java.util.*;
import JavaGroups.*;


/**
 *  Requires sample program EchoChannel to run at least once.
 */

public class SyncSendChannel implements MembershipListener {

    public void Start() {
	Channel  channel=new EnsChannel("SyncCallTest", null);
	SyncCall sync_call;
	Message  msg, rsp;

	try {
	    channel.SetMembershipListener(this);
	    channel.Connect(5000);
	    sync_call=new SyncCall(channel);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
	
	for(int i=0; i < 5; i++) {
	    System.out.println("\nSending synchronous message to group, receiving first reply");
	    try {
		rsp=sync_call.SendGetFirst(new String("Hello world").getBytes(), 3000);
	    }
	    catch(TimeoutException tex) {
		System.out.println("Encountered timeout");
		continue;
	    }
	    catch(Exception e) {
		System.err.println(e);
		continue;
	    }
	    if(rsp == null)
		System.err.println("Response is null");
	    else
		System.out.println("Response # " + rsp.GetId() + " from " + rsp.GetSrc() + ": " + 
				   new String(rsp.GetBuffer()));
	}

	channel.Disconnect();
	channel.Destroy();
    }


    public void ViewAccepted(Vector new_view) {
	System.out.println("Accepted view (" + new_view.size() + " members)");
    }


    public static void main(String args[]) {
	SyncSendChannel t;
	t=new SyncSendChannel();
	t.Start();
    }






    public static void active() {
	System.out.println(Thread.activeCount() + " active threads");
	PrintThreads();
    }



    public static void PrintThreads() {
	Thread threads[]=new Thread[Thread.activeCount()];
	int num=Thread.enumerate(threads);
	System.out.println("------- Threads -------");
	for(int i=0; i < threads.length; i++) {
	    System.out.println("#" + i + ": " + threads[i]);
	}
	System.out.println("------- Threads -------\n");
    }


    
}
