
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import JavaGroups.*;


public class QuoteClient extends Frame implements WindowListener, ActionListener, 
						  MembershipListener {
    private final String channel_name="Quotes";
    private Dispatcher   disp=new Dispatcher(new EnsChannelFactory(), null);

    private Button         get=new Button("Get"), set=new Button("Set");
    private Button         quit=new Button("Quit"), get_all=new Button("All");
    private Label          stock=new Label("Stock"), value=new Label("Value");
    private Label          err_msg=new Label("Error");
    private TextField      stock_field=new TextField(), value_field=new TextField();
    private java.awt.List  listbox=new java.awt.List();
    private final Font     default_font=new Font("Helvetica",Font.PLAIN,12);

    public QuoteClient() {
	super();
	addWindowListener(this);
	disp.SetMembershipListener(channel_name, this);
    }

    private void ShowMsg(String msg) {
	err_msg.setText(msg);
	err_msg.setVisible(true);
    }

    private void ClearMsg() {
	err_msg.setVisible(false);
    }


    public void Start() {
	setLayout(null);
	setSize(400, 300);
	setFont(default_font);

	stock.setBounds(new Rectangle(10, 30, 60, 30));
	value.setBounds(new Rectangle(10, 60, 60, 30));
	stock_field.setBounds(new Rectangle(100, 30, 100, 30));
	value_field.setBounds(new Rectangle(100, 60, 100, 30));
	listbox.setBounds(210, 30, 150, 160);
	err_msg.setBounds(new Rectangle(10, 200, 350, 30));
	err_msg.setFont(new Font("Helvetica",Font.ITALIC,12));
	err_msg.setForeground(Color.red);
	err_msg.setVisible(false);
	get.setBounds(new Rectangle(10, 250, 80, 30));
	set.setBounds(new Rectangle(100, 250, 80, 30));
	quit.setBounds(new Rectangle(190, 250, 80, 30));
	get_all.setBounds(new Rectangle(280, 250, 80, 30));

	get.addActionListener(this);
	set.addActionListener(this);
	quit.addActionListener(this);
	get_all.addActionListener(this);

	add(stock); add(value);
	add(stock_field); add(value_field);
	add(err_msg);
	add(get); add(set); add(quit); add(get_all);
	add(listbox);
	// stock_field.requestFocus();     
	setVisible(true);
    }



    public void windowActivated(WindowEvent e)   {}
    public void windowClosed(WindowEvent e)      {}
    public void windowClosing(WindowEvent e)     {System.exit(0);}
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e)   {}
    public void windowOpened(WindowEvent e)      {}


    public void actionPerformed(ActionEvent e) {
	String command=e.getActionCommand();
	try {
	    if(command == "Get") {
		String stock_name=stock_field.getText();
		if(stock_name == null || stock_name.length() == 0) {
		    ShowMsg("Stock name is empty !");
		    return;
		}
		ShowMsg("Looking up value for " + stock_name + ":");
		Float val=(Float)disp.SendGetFirst(channel_name, "GetQuote", stock_name, 3000);
		if(val != null) {
		    value_field.setText(val.toString());
		    ClearMsg();
		}
		else {
		    value_field.setText("");
		    ShowMsg("Value for " + stock_name + " not found");
		}
	    }
	    else if(command == "Set") {
		String stock_name=stock_field.getText();
		String stock_val=value_field.getText();
		if(stock_name == null || stock_val == null || stock_name.length() == 0 ||
		   stock_val.length() == 0) {
		    ShowMsg("Stock name and value have to be present to enter a new value");
		    return;
		}
		Float val=new Float(stock_val);
		disp.SendGetN(channel_name, "SetQuote", stock_name, val, 0, 0);
		ShowMsg("Stock " + stock_name + " set to " + val);
	    }
	    else if(command == "All") {
		listbox.removeAll();
		ShowMsg("Getting all stocks:");
		Hashtable all_stocks=(Hashtable)disp.SendGetFirst(channel_name, 
								  "GetAllStocks", null, 6000);
		if(all_stocks == null) {
		    ShowMsg("No stocks found");
		    return;
		}
		ClearMsg();
		listbox.removeAll();
		String key;
		Float val;
		for(Enumeration en=all_stocks.keys(); en.hasMoreElements();) {
		    key=(String)en.nextElement();
		    val=(Float)all_stocks.get(key);
		    if(val == null)
			continue;
		    listbox.add(key + ": " + val.toString());
		}
	    }
	    else if(command == "Quit") {
		setVisible(false);
		disp.Destroy();
		System.exit(0);
	    }
	    else
		System.out.println("Unknown action");
	}
	catch(Exception ex) {
	    value_field.setText("");
	    ShowMsg(ex.toString());
	}
    }


    public void ViewAccepted(Vector new_view) {
	setTitle("Members in " + channel_name + ": " + (new_view.size() -1));
    }

    
    public static void main(String args[]) {
	QuoteClient client=new QuoteClient();
	client.Start();
    }
	
}
