
import java.net.*;
import java.util.*;
import JavaGroups.*;

/**
 * We just return messages that come in by swapping the destination and source
 * addresses. At the Transport level, we don't care to which object a Message is sent
 * (as in the Dispatcher, where messages can only be sent to either single objects or to
 * groups). Rather we accept all messages and return them immediately. Similar to the
 * Internet Echo service, which just returns the packet received to the sender using
 * ICMP.
 */

public class EchoChannel implements MembershipListener {
    private Channel channel;
    private String  name="SyncCallTest";

    public EchoChannel(String n) {name=n;}
    public EchoChannel()         {}


    public void Start() {
	Message  msg, rsp;
	String   rsp_str;

	System.out.println("Creating channel for '" + name + "'");
	channel=new EnsChannel(name, null);
	channel.SetMembershipListener(this);
	try {
	    channel.Connect(0);
	    System.out.println("Waiting for messages");
	    while((msg=channel.Receive(0)) != null) {
		System.out.println("Received message (id=" + msg.GetId() + ")");
		rsp=msg.MakeReply();
		rsp_str=new String("Response to '" + new String(msg.GetBuffer()) + "'");
		rsp.SetBuffer(rsp_str.getBytes());
		System.out.println("Sending rsp: " + rsp);
		channel.Send(rsp);
	    }
	    channel.Disconnect();
	    channel.Destroy();	
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

    public void ViewAccepted(Vector new_view) {
	System.out.println("Accepted new view (" + new_view.size() + " members)");
    }
    

    public static void main(String args[]) {
	EchoChannel me;
	if(args.length == 1)
	    me=new EchoChannel(args[0]);
	else
	    me=new EchoChannel();
	me.Start();
    }

    
    
    
}
