import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import JavaGroups.*;



public class DrawRepl implements MouseMotionListener, WindowListener, ActionListener,
				 Runnable {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private byte                   buf[]=new byte[128];
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private ByteArrayInputStream   inp;
    private DataInputStream        instream;
    private int                    x, y;
    private Hashtable              colors=new Hashtable();
    private Random                 random=new Random(System.currentTimeMillis());
    private int                    col_val=1;
    private Color                  current_color=Color.red;
    private Button                 clear_button, leave_button;
    private String                 groupname="DrawReplGroup";
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);

    private EventQueue             event_queue=null;
    private Thread                 mythread=null;
    private Dispatcher             dispatcher;


    public DrawRepl() {
	colors.put(new Integer(1),  Color.white);
	colors.put(new Integer(2),  Color.black);
	colors.put(new Integer(3),  Color.red);
	colors.put(new Integer(4),  Color.orange);
	colors.put(new Integer(5),  Color.green);
	colors.put(new Integer(6),  Color.magenta);
	colors.put(new Integer(7),  Color.cyan);
	colors.put(new Integer(8),  Color.blue);
	mythread=new Thread(this);
	dispatcher=new Dispatcher(new EnsChannelFactory(), null);
	dispatcher.SetMethodLookup(new MethodLookupClos());
    }


    public static void main(String[] args) {
	DrawRepl draw=new DrawRepl();
	draw.go();
    }


    private Color SelectColor() {
	col_val=(Math.abs(random.nextInt()) % 8)+1;
	Color ret=(Color)colors.get(new Integer(col_val));
	if(ret == null)
	    ret=Color.red;
	return ret;
    }



    AWTEvent CopyEvent(Component src, AWTEvent evt) {

	if(evt instanceof MouseEvent) {
	    MouseEvent mev=(MouseEvent)evt;
	    return new MouseEvent(src, evt.getID(), mev.getWhen(), mev.getModifiers(),
				  mev.getX(), mev.getY(), mev.getClickCount(),
				  mev.isPopupTrigger());
	}

	if(evt instanceof KeyEvent) {
	    KeyEvent kev=(KeyEvent)evt;
	    return new KeyEvent(src, evt.getID(), kev.getWhen(), kev.getModifiers(), 
				kev.getKeyCode(), kev.getKeyChar());
	}

	if(evt instanceof ActionEvent)
	    return new ActionEvent(src, evt.getID(), ((ActionEvent)evt).getActionCommand(),
				   ((ActionEvent)evt).getModifiers());


	if(evt instanceof PaintEvent)
	    return new PaintEvent(src, evt.getID(), ((PaintEvent)evt).getUpdateRect());


	if(evt instanceof FocusEvent)
	    return new FocusEvent(src, evt.getID(), ((FocusEvent)evt).isTemporary());

	if(evt instanceof ComponentEvent)
	    return new ComponentEvent(src, evt.getID());
				
	return null;
    }



    void Dispatch(Object src, AWTEvent evt) {
 	if (src instanceof Component)
 	    ((Component)src).dispatchEvent(evt);
	else if (src instanceof MenuComponent)
 	    ((MenuComponent)src).dispatchEvent(evt);
 	else
 	    System.err.println("++++++++++");	
    }
    

    public Component FindComponent(Container parent, String comp_name) {
	Component  retval=null;

	if(comp_name != null && comp_name.equals(parent.getName()))
	    return parent;

	int ncomponents = parent.getComponentCount();
        Component components[] = parent.getComponents();
	for (int i = ncomponents-1 ; i >= 0; i--) {
	    Component comp = components[i], tmp;
	    if (comp != null) {
		if(comp instanceof Container) {
		    retval=FindComponent((Container)comp, comp_name);
		    if(retval != null)
			return retval;
		}
		else if(comp_name.equals(comp.getName()))
		    return comp;
	    }
	}
	return retval;
    }


    // public void SetSize(Integer x, Integer y) {
    //   mainFrame.setSize(new Dimension(x.intValue(), y.intValue()));
    // }


    /* Called by Dispatcher */
    public void ProcessEvent(String comp_name, AWTEvent evt) {
	AWTEvent   copy_evt=null;
	Component  src=FindComponent(mainFrame, comp_name);
	if(src == null) {
	    System.err.println("ProcessEvent(): src is null");
	    return;
	}

	System.out.println("Received " + evt.getClass().getName());

	copy_evt=CopyEvent(src, evt);
	if(copy_evt == null) {
	    System.err.println("copy_evt is NULL");
	    return;
	}
	Dispatch(src, copy_evt);


// 	if(evt instanceof ComponentEvent && evt.getID() == ComponentEvent.COMPONENT_RESIZED) {
// 	    Dimension dim=mainFrame.getSize();
// 	    try {
// 		dispatcher.SendGetN(groupname, "SetSize", new Integer(dim.height),
// 				    new Integer(dim.width), 0, 0);
// 	    }
// 	    catch(Exception e) {
// 		System.err.println(e);
// 	    }
// 	}
    }


    void ProcessLocally(AWTEvent evt) {
	Dispatch(evt.getSource(), evt);
    }



    public void run() {
	String comp_name;
	
	while(true) {
	    try {
		AWTEvent evt=event_queue.getNextEvent();
		Object obj=evt.getSource();
		if(obj == null) {
		    System.err.println("src is NULL");
		    continue;
		}		

		if(obj instanceof Component)
		    comp_name=((Component)obj).getName();
		else if(obj instanceof MenuComponent)
		    comp_name=((MenuComponent)obj).getName();
		else {
		    System.err.println("src is of type " + obj.getClass().getName());
		    continue;
		}

		if(evt instanceof FocusEvent || evt instanceof PaintEvent) {
		    System.out.println(evt.getClass().getName() + " not copied");
		    ProcessLocally(evt);
		    continue;
		}
		System.out.println("MCasting "+evt.getClass().getName()+" event...");
		dispatcher.SendGetN(groupname, "ProcessEvent", 
				    comp_name, evt, 0, 0);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



	
    public void go() {
	dispatcher.Join(groupname, this);
	mainFrame=new Frame();
	panel=new Panel();
	sub_panel=new Panel();
	
	event_queue=mainFrame.getToolkit().getSystemEventQueue();
	mythread.start();
	
	mainFrame.setSize(200,200);
	mainFrame.add("Center", panel);
	clear_button=new Button("Clear");
	clear_button.setFont(default_font);
	clear_button.addActionListener(this);
	leave_button=new Button("Exit");
	leave_button.setFont(default_font);
	leave_button.addActionListener(this);
	sub_panel.add("South", clear_button);
	sub_panel.add("South", leave_button);
	mainFrame.add("South", sub_panel);

	mainFrame.addWindowListener(this);
	// mainFrame.addComponentListener(this);

	panel.addMouseMotionListener(this);

	mainFrame.setVisible(true);

	graphics=panel.getGraphics();
	current_color=SelectColor();
	if(current_color == null)
	    current_color=Color.red;
	graphics.setColor(current_color);
    }



    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
	x=e.getX();
	y=e.getY();
	graphics.fillOval(x, y, 10, 10);
    }


    public void ClearPanel() {

	System.out.println("CLEAR");

	Rectangle  bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }



    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}



//     public void componentResized(ComponentEvent e) {
// 	System.out.println("RESIZED, size is " + mainFrame.getBounds());
//     }

//     public void componentMoved(ComponentEvent e) {
// 	System.out.println("MOVED, location is: " + mainFrame.getLocation());
//     }

//     public void componentShown(ComponentEvent e) {}

//     public void componentHidden(ComponentEvent e) {}




    public void actionPerformed(ActionEvent e) {
	String command=e.getActionCommand();
	if(command.equals("Clear"))
	    ClearPanel();
	else if(command.equals("Exit")) {
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }


}

