
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

import JavaGroups.Ensemble.*;


public class DrawOutboard implements Hot_Callbacks, MouseMotionListener, 
				     WindowListener, ActionListener {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private byte                   buf[]=new byte[128];
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private ByteArrayInputStream   inp;
    private DataInputStream        instream;
    private int                    x, y;
    private Hashtable              colors=new Hashtable();
    private Random                 random=new Random(System.currentTimeMillis());
    private int                    col_val=1;
    private Color                  current_color=Color.red;
    private Button                 clear_button, leave_button;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private String                 groupname="DrawOutboardGroup";


    private Hot_Ensemble           ensemble=null;
    private Thread                 ens_thread=null;
    private Hot_GroupContext       group_id=null;
    private Hot_JoinOps            options=null;
    private int                    member_size=0;


    public DrawOutboard(String name) {
	this();
	groupname=name;
    }


    public DrawOutboard() {
	try {
	    ensemble=new Hot_Ensemble();
	    ens_thread=new Thread(ensemble);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	colors.put(new Integer(1),  Color.white);
	colors.put(new Integer(2),  Color.black);
	colors.put(new Integer(3),  Color.red);
	colors.put(new Integer(4),  Color.orange);
	colors.put(new Integer(5),  Color.green);
	colors.put(new Integer(6),  Color.magenta);
	colors.put(new Integer(7),  Color.cyan);
	colors.put(new Integer(8),  Color.blue);
    }


    public static void main(String[] args) {
	DrawOutboard draw;
	if(args.length == 1)
	    draw=new DrawOutboard(args[0]);
	else
	    draw=new DrawOutboard();
	draw.go();
    }


    private Color SelectColor() {
	col_val=(Math.abs(random.nextInt()) % 8)+1;
	Color ret=(Color)colors.get(new Integer(col_val));
	if(ret == null)
	    ret=Color.red;
	return ret;
    }


	
    public void go() {
	Hot_Error        rc;
	Hot_GroupContext tmp[]=new Hot_GroupContext[1];

	try {
	    ens_thread.start();
	    options=new Hot_JoinOps();
	    options.heartbeat_rate=5000;
	    options.transports="UDP";
	    options.protocol="Top:Heal:Switch:Leave:Inter:Intra:Elect:Merge:" + 
		"Sync:Suspect:Top_appl:Pt2ptw:Pt2pt:Frag:Stable:Mnak:Bottom";
	    options.group_name=groupname;
	    options.params="primary_quorum=2:int;suspect_max_idle=3:int;suspect_sweep=3.000:time";
	    options.conf=this;
	    options.use_properties=true;
	    rc=ensemble.Join(options, tmp);
	    if(rc != null) {
		System.err.println("Error in JOIN: " + rc);
		System.exit(-1);
	    }
	    group_id=tmp[0];

	    mainFrame=new Frame();
	    panel=new Panel();
	    sub_panel=new Panel();
	    mainFrame.setSize(200,200);
	    mainFrame.add("Center", panel);
	    clear_button=new Button("Clear");
	    clear_button.setFont(default_font);
	    clear_button.addActionListener(this);
	    leave_button=new Button("Leave & Exit");
	    leave_button.setFont(default_font);
	    leave_button.addActionListener(this);
	    sub_panel.add("South", clear_button);
	    sub_panel.add("South", leave_button);
	    mainFrame.add("South", sub_panel);
	    mainFrame.addWindowListener(this);
	    panel.addMouseMotionListener(this);
	    mainFrame.setVisible(true);
	    mainFrame.setTitle(member_size + " mbrs");
	    graphics=panel.getGraphics();
	    current_color=SelectColor();
	    if(current_color == null)
		current_color=Color.red;
	    graphics.setColor(current_color);	    
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }



    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {
	Hot_Error    rc;
	Hot_Message  msg;
	int          tmp[]=new int[1]; tmp[0]=0;

	x=e.getX();
	y=e.getY();
	graphics.fillOval(x, y, 10, 10);


	try {
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(col_val);
	    outstream.writeInt(x);
	    outstream.writeInt(y);
	    msg=new Hot_Message();
	    msg.setBytes(out.toByteArray());
	    rc=ensemble.Cast(group_id, msg, tmp);
	    if(rc != null)
		System.err.println("Cast failed: " + rc);
	    
	    out.reset();	
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }


    public void ClearPanel() {
	Rectangle  bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }


    public void SendClearPanelMsg() {
	Hot_Message  msg=new Hot_Message();
	Hot_Error    rc;
	int          tmp[]=new int[1]; tmp[0]=0;

	ClearPanel();

	try {
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(-1);
	    msg.setBytes(out.toByteArray());

	    rc=ensemble.Cast(group_id, msg, tmp);
	    if(rc != null)
		System.err.println("Cast failed: " + rc);

	    out.reset();	
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }




    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	Hot_Error  rc;
	String     command=e.getActionCommand();	
	if(command == "Clear")
	    SendClearPanelMsg();
	else if(command == "Leave & Exit") {
	    rc=ensemble.Leave(group_id);
	    if(rc != null)
		System.err.println("LEAVE failed: " + rc);
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }



    public synchronized void ReceiveCast(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {
 	int my_x=10, my_y=10;
	Color c=Color.red;
	int   cval;
	Color old_col=current_color;
	instream=new DataInputStream(new ByteArrayInputStream(msg.getBytes()));
	try {
	    cval=instream.readInt();
	    if(cval == -1) {
		ClearPanel();
		return;
	    }
	    my_x=instream.readInt();
	    my_y=instream.readInt();
	    c=(Color)colors.get(new Integer(cval));
	    if(c == null)
		c=Color.red;
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	graphics.setColor(c);
	graphics.fillOval(my_x, my_y, 10, 10);
	graphics.setColor(old_col);	
    }


    public void ReceiveSend(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {
	
    }


    public void AcceptedView(Hot_GroupContext gctx, Object env, Hot_ViewState viewState) {

	System.out.println("Acepted view, gctx: " + gctx);
	System.out.println("View State: " + viewState);

	member_size=viewState != null ? viewState.nmembers : 1;
	if(mainFrame != null)
	    mainFrame.setTitle(member_size + " mbrs");
    }


    public void Heartbeat(Hot_GroupContext gctx, Object env, int rate) {
	
    }


    public void Block(Hot_GroupContext gctx, Object env) {
	
    }


    public void Exit(Hot_GroupContext gctx, Object env) {
	System.out.println("Received EXIT msg, exiting...");
	System.exit(0);
    }




}

