
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

import JavaGroups.*;


public class Puzzle extends Frame implements WindowListener, ColorUpdated, MessageListener {
    private ColorComp[]            components=new ColorComp[9];
    private Channel                channel;
    private PullPushAdapter        ad;
    private short                  channel_type=0;  // 0 = JChannel, 1 = EnsChannel

 
    public Puzzle(short channel_type) {
	this.channel_type=channel_type;
	components[0]=new ColorComp(0, Color.yellow);
	components[1]=new ColorComp(1, Color.blue);
	components[2]=new ColorComp(2, Color.red);
	components[3]=new ColorComp(3, Color.green);
	components[4]=new ColorComp(4, Color.white);
	components[5]=new ColorComp(5, Color.orange);
	components[6]=new ColorComp(6, Color.magenta);
	components[7]=new ColorComp(7, Color.cyan);
	components[8]=new ColorComp(8, Color.gray);
	
	for(int i=0; i < 9; i++) {
	    add(components[i]);
	    components[i].RegisterUpdateListener(this);
	}
	try {
	    if(channel_type == 1)
		channel=new EnsChannel("ColorDemo", null);
	    else
		channel=new JChannel("ColorDemo", "UDP(mcast=true;loopback=false)");
	    channel.Connect(3000);
	    ad=new PullPushAdapter(channel);
	    ad.SetListener(this);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public static void main(String[] args) {
	short  channel_type=0;
	Puzzle puzzle;

	if(args.length == 1)
	    if(args[0].equals("ens"))
		channel_type=1;

	puzzle=new Puzzle(channel_type);
	puzzle.go();
    }



	
    public void go() {
	try {
	    setSize(200,200);
	    setLayout(new GridLayout(3, 3));
 	    addWindowListener(this);
	    setVisible(true);
	    setTitle("Color Puzzle");
	    setBackground(Color.white);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }



    /* --------------- Callbacks --------------- */


    public synchronized void Updated(int comp_nr, int red, int green, int blue) {
	byte[] msg;
	ByteArrayOutputStream os=new ByteArrayOutputStream(12);
	DataOutputStream data=new DataOutputStream(os);
	try {
	    data.writeInt(comp_nr);
	    data.writeInt(red);
	    data.writeInt(green);
	    data.writeInt(blue);
	    msg=os.toByteArray();
	    channel.Cast(msg);
	    data.close();
	    os.close();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public synchronized void Receive(Message msg) {
	ByteArrayInputStream in=new ByteArrayInputStream(msg.GetBuffer());
	DataInputStream      data=new DataInputStream(in);
	int                  index, red, green, blue;
	
	try {
	    index=data.readInt();
	    red=data.readInt();
	    green=data.readInt();
	    blue=data.readInt();
	    components[index].SetColor(new Color(red, green, blue));
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	setVisible(false);
	channel.Disconnect();
	channel.Destroy();
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


}

