
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ColorComp extends Component implements MouseListener {    
    private int           comp_nr;
    private Color         current_color;
    private int           red, green, blue;
    private final int     delta=15;
    private ColorUpdated  up;
    

    public ColorComp(int comp_nr, Color initial_color) {
	this.comp_nr=comp_nr;
	current_color=initial_color;
	addMouseListener(this);
	red=current_color.getRed();
	green=current_color.getGreen();
	blue=current_color.getBlue();
    }


    public void RegisterUpdateListener(ColorUpdated up) {
	this.up=up;
    }
    

    public void paint(Graphics g) {
	Rectangle bounds=getBounds();
	g.setColor(current_color);
	g.fillRect(1, 1, bounds.width-2, bounds.height-2);
    }

    public synchronized void SetColor(Color c) {
	current_color=c;
	repaint();
    }


    public void mouseClicked(MouseEvent e) {
	HandleMouseEvent(e);
    }


    public void mousePressed(MouseEvent e) {
	HandleMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
	HandleMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
	HandleMouseEvent(e);
    }

    public void mouseExited(MouseEvent e) {
	HandleMouseEvent(e);
    }


    void HandleMouseEvent(MouseEvent evt) {
	int mod=evt.getModifiers();

	if(evt.getID() == evt.MOUSE_CLICKED) {	    
	    if(mod == evt.BUTTON1_MASK) {
		red=red-delta;
		if(red <= 0)
		    red=255;
	    }
	    else if(mod == evt.BUTTON1_MASK + evt.SHIFT_MASK)
		red=(red+delta) % 255;

	    if(mod == evt.BUTTON2_MASK) {
		green=green-delta;
		if(green <= 0)
		    green=255;
	    }
	    else if(mod == evt.BUTTON2_MASK + evt.SHIFT_MASK)
		green=(green+delta) % 255;

	    if(mod == evt.BUTTON3_MASK) {
		blue=blue-delta;
		if(blue <= 0)
		    blue=255;
	    }
	    else if(mod == evt.BUTTON3_MASK + evt.SHIFT_MASK)
		blue=(blue+delta) % 255;

	    current_color=new Color(red, green, blue);
	    repaint();
	    if(up != null)
		up.Updated(comp_nr, red, green, blue);
	}
    }

}
