
import java.util.*;
import JavaGroups.*;

public class ChannelTestRandom implements Runnable, MembershipListener {
    private Channel channel=null;
    private Thread  mythread=null;
    private Vector  members=null;
    private Random  rand=new Random(System.currentTimeMillis());
    private Integer mutex=new Integer(0);


    private Object GetRandomMember() {
	Object target=null;
	int    index, len, r;
	if(members == null || members.size() < 2)
	    return null;
	len=members.size();
	r=Math.abs(rand.nextInt()) + 32;
	index=Math.abs((r % len));
	target=members.elementAt(index);
	return target;
    }

    public void Start() throws Exception {
	Object  target=null, my_addr;
	int     i=1;

	try {
	    channel=new EnsChannel("TestChannel", null);
	    channel.SetMembershipListener(this);
	    channel.Connect(5000);
	    mythread=new Thread(this, "ChannelTestRandomThread");
	    mythread.start();

	    while(true) {
		synchronized(mutex) {
// 		    if(members != null && members.size() < 2) {
// 			Thread.currentThread().sleep(2000);
// 			System.out.println("sleeping");
// 			continue;
// 		    }
		    target=GetRandomMember();
		}
		if(target != null) {
		    System.out.println("Sending message to " + target);
		    my_addr=channel.GetAddress();
		    if(target.equals(my_addr))
			System.out.println("Oops, that's me !");
		    else
			channel.Send(target, new String("This is msg #" + i++).getBytes());
		}
		Thread.currentThread().sleep(1000);
	    }
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public void run() {
	Message msg;
	while(true) {
	    try {
		msg=channel.Receive(0); // no timeout
		System.out.println(new String(msg.GetBuffer()));
	    }
	    catch(NotConnected conn) {
		System.err.println("DISCONNECTED");
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    public synchronized void ViewAccepted(Vector new_view) {
	System.out.println("New view installed: " + new_view);
	synchronized(mutex) {
	    members=new_view;
	}
    }
    


    public static void main(String args[]) {
	ChannelTestRandom test;
	try {
	    test=new ChannelTestRandom();
	    test.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
   
}
