
import java.util.*;
import JavaGroups.*;

public class ChannelTest implements Runnable, MembershipListener {
    private Channel channel=null;
    private Thread  mythread=null;



    public static void active() {
	System.out.println(Thread.activeCount() + " active threads");
	PrintThreads();
    }



    public static void PrintThreads() {
	Thread threads[]=new Thread[Thread.activeCount()];
	int num=Thread.enumerate(threads);
	System.out.println("------- Threads -------");
	for(int i=0; i < threads.length; i++) {
	    System.out.println("#" + i + ": " + threads[i]);
	}
	System.out.println("------- Threads -------\n");
    }



    public void Start() throws Exception {
	channel=new EnsChannel("TestChannel", null);
	channel.Connect(3000);
	channel.SetMembershipListener(this);
	mythread=new Thread(this, "ChannelTestThread");
	mythread.start();
	for(int i=0; i < 10; i++) {
	    System.out.println("Casting msg #" + i);
	    channel.Cast(new String("This is msg #" + i).getBytes());
	    Thread.currentThread().sleep(1000);
	}
	channel.Disconnect();
	channel.Destroy();
	mythread.stop();
    }


    public void run() {
	Message msg;
	while(true) {
	    try {
		msg=channel.Receive(0); // no timeout
		System.out.println(new String(msg.GetBuffer()));
		// channel.Send(msg.GetSrc(), new String("This is a response").getBytes());
	    }
	    catch(NotConnected conn) {
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    public void ViewAccepted(Vector new_view) {
	System.out.println("The new view is: " + new_view);
    }
    


    public static void main(String args[]) {
	ChannelTest test;
	try {
	    test=new ChannelTest();
	    test.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
   
}
