package JavaGroups;

import java.util.*;

/**
 * SyncCall objects are intended to be used on objects that implement the Transportable
 * interface. They allow to emulate <em>synchronous message exchange</em> on top of an 
 * <em>asynchronous</em> message transport, that is the sending
 * of a message to a group (or a single member) and the reception of the result in one step.
 * When sending messages to a group, there might be none, one or more responses. The SyncCall
 * interface allows to specify how many responses should be returned (one, n, or all).
 * Additionally, a timeout defines the maximum amount of time to wait for the 
 * arrival of a message.
 */
public class SyncCall {
    private Transportable      transport=null;

    
    private Message SendGetFirst(Message m, long timeout) throws Exception {
	Message  retval=null;
	long     id=m.GetId(), start_time=System.currentTimeMillis(), time_spent=0;
	
	transport.Send(m);
	
	while(true) {
	    if(timeout <= 0)
		retval=transport.Receive(0);
	    else
		retval=transport.Receive(timeout - time_spent);
	    if(retval == null)
		return null;

	    if(timeout > 0) {
		time_spent=System.currentTimeMillis() - start_time;
		if(time_spent >= timeout)
		    throw new TimeoutException();
	    }
	    if(retval.IsResponse() && retval.GetRspId() == id)
		return retval;
	}	
    }





    public SyncCall(Transportable t) {transport=t;}



    public Message Send(Object dest, byte[] msg, boolean oneway, long timeout) throws Exception {
	Message m=new Message(dest, null, msg);

	if(oneway) 
	    m.SetOneway();
	return SendGetFirst(m, timeout);
    }


    
    public Message SendGetFirst(byte[] msg, long timeout) throws Exception {
	Message  m=new Message(null, null, msg);

	return SendGetFirst(m, timeout);
    }



    public Vector SendGetN(byte[] msg, int expected_responses, long timeout) throws Exception {
	Message  m=new Message(null, null, msg), tmp=null;
	long     id=m.GetId();
	Vector   retval=new Vector();
	long     start_time=System.currentTimeMillis(), time_spent=0;
	int      num_responses=0;

	if(expected_responses < 1) {
	    m.SetOneway();
	    transport.Send(m);
	    return null;
	}
	transport.Send(m);

	while(num_responses < expected_responses) {

	    if(timeout > 0 && time_spent >= timeout) break;

	    try {
		if(timeout > 0)
		    tmp=(Message)transport.Receive(timeout - time_spent);
		else
		    tmp=(Message)transport.Receive(0);
		
		if(tmp != null && tmp.IsResponse() && tmp.GetRspId() == id) {
		    retval.addElement(tmp);
		    num_responses++;
		}	 
	    }
	    catch(TimeoutException tex) {		
	    }
	    time_spent=System.currentTimeMillis() - start_time;
	}
	return retval;
    }





}
