package JavaGroups;

import java.util.*;


public class Queue {
    private Vector  messages=new Vector();
    private boolean closed=false;


    public void Add(Object msg) throws Exception {	
	if(closed)
	    throw new QueueClosed();
	synchronized(messages) {
	    messages.addElement(msg);
	    Notify();
	}
    }


    public Object Remove() throws QueueClosed {  // removes from head, or blocks
	Object retval=null;
	synchronized(messages) {
	    while(messages.size() == 0) {
		if(closed)
		    throw new QueueClosed();
		try {
		    messages.wait();
		}
		catch(IllegalMonitorStateException ex) {
		    throw ex;
		}
		catch(Exception ex) {
		    System.err.println(ex);
		}
	    }
	    if(closed)
		throw new QueueClosed();
	    retval=messages.elementAt(0);
	    messages.removeElementAt(0);
	    return retval;
	}
    }


    public Object Remove(long timeout) throws QueueClosed, TimeoutException {
	Object retval=null;
	synchronized(messages) {
	    if(messages.size() == 0) {
		if(closed)
		    throw new QueueClosed();
		try {
		    messages.wait(timeout);
		}
		catch(IllegalMonitorStateException ex) {
		    throw ex;
		}
		catch(IllegalArgumentException ex2) {
		    throw ex2;
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	    if(closed)
		throw new QueueClosed();
	    if(messages.size() > 0) {
		retval=messages.elementAt(0);
		messages.removeElementAt(0);
	    }
	    else
		throw new TimeoutException();
	    return retval;
	}
    }


    public synchronized void Close() {
	closed=true;
	try {
	    notifyAll();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    public synchronized void Reset() {
	if(!closed)
	    Close();

	synchronized(messages) {
	    messages.removeAllElements();
	}
	closed=false;
    }


    protected void Notify() throws Exception {  // Data is available
	synchronized(messages) {
	    // messages.notifyAll();
	    messages.notify();   // only wake up next thread in line
	}
    }

    public int Size() {
	return messages.size();
    }

    public String toString() {
	return "Queue (" + Size() + ") messages";
    }

}
