package JavaGroups;

import java.util.*;


/**
 * Allows a client of <em>Channel</em> to be notified when messages have been received
 * instead of having to actively poll the channel for new messages. Typically used in the
 * client role (Receive()). As this class does not implement interface 
 * <code>Transportable</code>, but <b>uses</b> it for receiving messages, an underlying object
 * has to be used to send messages (e.g. the channel on which an object of this class relies).
 */
public class PullPushAdapter implements Runnable {
    protected Transportable    transport;
    protected MessageListener  listener=null;
    protected Thread           receiver_thread=null;
    
    
    public PullPushAdapter(Transportable t) {
	transport=t;
	Start();
    }
    
    public PullPushAdapter(Transportable t, MessageListener l) {
	transport=t;
	SetListener(l);
	Start();
    }

    public void Start() {
	receiver_thread=new Thread(this, "PullPushAdapterThread");
	receiver_thread.start();
    }

    public void Stop() {
	if(receiver_thread != null) {
	    receiver_thread.stop();
	    receiver_thread=null;
	}
    }
    
    public void SetListener(MessageListener l) {
	listener=l;
    }
    

    /**
     * Reentrant run(): message reception is serialized, then the listener is notified of the 
     * message reception
     */
    public void run() {
	Message          msg;
	MessageListener  l;

	while(true) {
	    try {
		msg=transport.Receive(0);
		if(listener != null)
		    listener.Receive(msg);
	    }
	    catch(NotConnected conn) {
		System.err.println(conn);
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }

}
