package JavaGroups;

import java.io.*;
import java.util.*;

/**
 * Allows to time execution of 'named' statements, counts number of times called and total
 * execution time.
 */
public class Profiler {

    static public class Entry {
	long    num_calls=0;
	long    tot_time=0;
	double  avg=0;
	long    start_time=0;
	long    stop_time=0;

	synchronized void Compute() {
	    num_calls++;
	    tot_time+=stop_time-start_time;
	    avg=tot_time/num_calls;
	}
    }


    private static OutputStream  os=null;
    private static Hashtable     entries=new Hashtable();


    public Profiler() {
	try {
	    System.out.println("ctor was called");
	    os=new FileOutputStream("profiler.dat");
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    public static void SetFilename(String filename) {
	try {
	    if(os != null) {
		os.close();
	    }
	    os=new FileOutputStream(filename);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public static void Start(String call_name) {
	Entry e=(Entry)entries.get(call_name);
	if(e == null) {
	    e=new Entry();
	    entries.put(call_name, e);
	}
	e.start_time=System.currentTimeMillis();	    
    }


    public static void Stop(String call_name) {
	Entry e=(Entry)entries.get(call_name);
	if(e == null) {
	    System.err.println("Profiler.Stop(): entry for " + call_name + " not found");
	    return;
	}
	e.stop_time=System.currentTimeMillis();
	e.Compute();
    }


    public static void Dump() { // dump to file
	String key;
	Entry  val;
	if(os == null) {
	    System.err.println("Profiler.Dump(): output file is null");
	    return;
	}
	for(Enumeration e=entries.keys(); e.hasMoreElements();) {
	    key=(String)e.nextElement();
	    val=(Entry)entries.get(key);
	    try {
		os.write(new String(key + ": " + val.num_calls + " " + 
				    val.tot_time + " " + val.avg + "\n").getBytes());
	    }
	    catch(Exception ex) {
		System.err.println(ex);
	    }
	}
    }


    public static void main(String[] args) {
	Profiler.SetFilename("bela.out");


	try {
	 
	    Profiler.Start("time1");
	    Thread.currentThread().sleep(1500);
	    Profiler.Stop("time1");
	 
	    Profiler.Start("time1");
	    Thread.currentThread().sleep(1500);
	    Profiler.Start("time2");
	    Thread.currentThread().sleep(500);
	 
	    Profiler.Stop("time2");
	    Thread.currentThread().sleep(1500);
	    Profiler.Stop("time1");
	 


	    Profiler.Dump();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
