package JavaGroups;

import java.io.*;
import java.util.*;

import JavaGroups.JavaStack.*;

public class Message implements Serializable {
    protected Object        dest_addr=null;
    protected Object        src_addr=null;
    protected byte[]        buf=null;
    protected long          id=0;
    protected long          rsp_id=0;  // in case it is a response
    protected boolean       oneway=false;
    protected static long   curr_id=1;
    protected Stack         headers=new Stack();


    protected synchronized static long GetCurrentId() {
	return curr_id++;
    }
    

    /** Public constructor
     *  @param dest Address of receiver. If it is <em>null</em> or a <em>string</em>, then
     *              it is sent to the group (either to current group or to the group as given
     *              in the string). If it is a Vector, then it contains a number of addresses
     *              to which it must be sent. Otherwise, it contains a single destination.<p>
     *              Addresses are generally untyped (all are of type <em>Object</em>. A channel
     *              instance must know what types of addresses it expects and downcast
     *              accordingly.
     *  @param src  Address of sender
     *  @param buf  Message to be sent
     */
    public Message(Object dest, Object src, byte[] buf) {
	dest_addr=dest;
	src_addr=src;
	this.buf=buf;
	id=GetCurrentId();
    }

    // Only used for Externalization (creating an initial object)
    public Message() {}

    public Object  GetDest()                {return dest_addr;}
    public void    SetDest(Object new_dest) {dest_addr=new_dest;}
    public Object  GetSrc()                 {return src_addr;}
    public void    SetSrc(Object new_src)   {src_addr=new_src;}
    public byte[]  GetBuffer()              {return buf;}
    public void    SetBuffer(byte[] b)      {buf=b;}
    public long    GetId()                  {return id;}
    public void    SetId(long id)           {this.id=id;}
    public boolean IsResponse()             {return rsp_id > 0;}
    public long    GetRspId()               {return rsp_id;}
    public void    SetRspId(long i)         {rsp_id=i;}
    public boolean IsOneway()               {return oneway;}
    public void    SetOneway()              {oneway=true;}
    public Stack   GetHeaders()             {return headers;}
    public void    SetHeaders(Stack h)      {headers=h;}

    /*---------------------- Used by protocol layers ----------------------*/
    
    public void   AddHeader(Serializable hdr)  {
	headers.push(new Header(hdr));
	// System.out.println("Message.AddHeader(): msg is " + id + ", hdr is " + PeekHeader());
    }

    public Object RemoveHeader() {
	try {
	    // System.out.println("Message.RemoveHeader(): msg is " + id + ", hdr is " + PeekHeader());
	    return (Object)((Header)headers.pop()).GetObject();
	}
	catch(EmptyStackException e) {
	    return null;
	}
    }

    public Object PeekHeader() {
	try {
	    return (Object)((Header)headers.peek()).GetObject();
	}
	catch(EmptyStackException e) {
	    return null;
	}
    }
    /*---------------------------------------------------------------------*/


    public Message Copy() {
	Message retval=new Message();
	retval.dest_addr=dest_addr;
	retval.src_addr=src_addr;
	retval.buf=buf;
	retval.id=id;
	retval.rsp_id=rsp_id;
	retval.oneway=oneway;
	retval.headers=(Stack)headers.clone();
	return retval;
    }


    public Message MakeReply() {
	Message retval=new Message(src_addr, null, null);
	retval.SetRspId(id);
	return retval;
    }



    public String toString() {
	StringBuffer ret=new StringBuffer();
	ret.append("[ID: " + id);
	if(rsp_id > 0)
	    ret.append(" (rsp_id=" + rsp_id + ")");
	ret.append(", dest: ");
	if(dest_addr == null)
	    ret.append("<null>");
	else
	    ret.append(dest_addr);
	ret.append(", src: ");
	if(src_addr == null)
	    ret.append("<null>");
	else
	    ret.append(src_addr);

	if(!headers.empty())
	    ret.append(" (" + headers.size() + " headers)");

	ret.append(", size = ");
	if(buf != null && buf.length > 0)
	    ret.append(buf.length);
	else
	    ret.append("0");
	ret.append(" bytes");
	if(oneway)
	    ret.append(", oneway");
	ret.append("]");
	return ret.toString();
    }


    /**
       Returns size of buffer plus size of all headers plus a fixed overhead (other fields of
       Message, marshaling code etc.
     */
    public long Size() {
	long retval=buf != null ? buf.length : 0;

	for(int i=0; i < headers.size(); i++)
	    retval+=((Header)headers.elementAt(i)).Size();
	
	return retval + 1024; // ??????
    }



//     public void writeExternal(ObjectOutput out) throws IOException {
// 	out.writeObject(dest_addr);
// 	out.writeObject(src_addr);
// 	if(buf == null)
// 	    out.writeInt(0);
// 	else {
// 	    out.writeInt(buf.length);
// 	    out.write(buf);
// 	}
// 	out.writeLong(id);
// 	out.writeLong(rsp_id);
// 	out.writeBoolean(oneway);
// 	out.writeObject(headers);
//     }



//     public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
// 	int tmp;

// 	dest_addr=in.readObject();
// 	src_addr=in.readObject();
// 	tmp=in.readInt();
// 	if(tmp != 0) {
// 	    buf=new byte[tmp];
// 	    in.readFully(buf);
// 	}
// 	id=in.readLong();
// 	rsp_id=in.readLong();
// 	oneway=in.readBoolean();
// 	headers=(Stack)in.readObject();
//     }



    public static void main(String[] args) {
	Message m=new Message(null, null, new String("Hello world").getBytes());

	System.out.println("Size: " + m.Size());

	m.AddHeader(new Header("Bela Ban"));
	System.out.println("Size: " + m.Size());

	m.AddHeader(new Header("Bela Ban"));
	System.out.println("Size: " + m.Size());

	m.AddHeader(new Header("Bela Ban"));
	m.AddHeader(new Header("Bela Ban"));
	m.AddHeader(new Header("Bela Ban"));

	System.out.println(m);

	Message copy=m.Copy();
	System.out.println(copy);

	copy.RemoveHeader();
	System.out.println(copy);
	System.out.println(m);


    }




}
