package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.net.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;


/**
 * Algorithm for this class:<p>
 * <li>Receive a UDP packet
 * <li>all receive_prot.Receive() to pass it up to the next layer above us
 * Messages received by this thread flow up from the bottom to the top of the stack,
 * that is, towards the Transport object (and eventually towards the application).
 */

public class UdpMcastReceiverThread extends Thread {    
    MulticastSocket           sock=null;
    private UDP               udp_prot;
    private boolean           loopback=true;
    private InternetAddress   mcast_addr;
    private String            default_ip="230.10.10.10";
    private final int         default_port=7500;
    private String            channel_name;


    public UdpMcastReceiverThread(UDP udp, String ip_mcast_addr) {
	setName("UdpMcastReceiverThread");
	udp_prot=udp;
	if(ip_mcast_addr != null)
	    default_ip=ip_mcast_addr;
	channel_name=udp_prot.GetProtocolStack().GetChannelName();
	if(channel_name == null)
	    System.err.println("UdpMcastReceiverThread(): cannot get channel name; will not " +
			       "be able to discard messages destined for different channels");
    }


    public boolean          GetMulticastLoopback()           {return loopback;}
    public void             SetMulticastLoopback(boolean f)  {loopback=f;}
    public InternetAddress  GetMcastAddress()                {return mcast_addr;}



    public void Stop() {
	if(sock != null) {
	    if(mcast_addr != null) {
		try {
		    sock.leaveGroup(mcast_addr.GetIpAddress());
		    mcast_addr=null;
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	    sock.close();
	    sock=null;
	}
    }

    

    public void run() {
	ByteArrayInputStream inp_stream;
	ObjectInputStream    inp;
	Message              msg;
	DatagramPacket       packet;
	byte                 receive_buf[]=new byte[65000];
	Protocol             up_prot;
	InetAddress          tmp_addr=null;
	InternetAddress      local_addr;

	loopback=udp_prot.GetLoopback();
	local_addr=(InternetAddress)udp_prot.GetLocalAddress();
	

	try {
	    tmp_addr=InetAddress.getByName(default_ip);
	}
	catch(Exception e) {
	    System.err.println("Failed to get IP Mcast address for " + default_ip + 
			       ", trying 230.10.10.10");
	}
	
	try {
	    if(tmp_addr == null)
		tmp_addr=InetAddress.getByName("230.10.10.10");
	    sock=new MulticastSocket(default_port);
	    mcast_addr=new InternetAddress(tmp_addr, 
					   sock.getLocalPort()); // should be same as default_port
	    sock.joinGroup(tmp_addr);

	    //System.out.println("UDP: joined ip mcast address " + 
	    //	       tmp_addr.getHostAddress() + ":" + default_port);


	    /* Notify UDP object that we now have an MCAST address, so it can proceed */
	    synchronized(udp_prot) {
		udp_prot.notify();
	    }
	}
	catch(Exception e) {
	    System.err.println("UdpMcastReceiverThread: " + e);
	    return;
	}	

	up_prot=udp_prot.GetUpProtocol();

	if(up_prot == null) {
	    System.err.println("UdpMcastReceiverThread.run(): layer above me is null; " +
			       "discarding message !");
	    return;
	}

	while(true) {		
	    try {
		packet=new DatagramPacket(receive_buf, receive_buf.length);
		sock.receive(packet);
		inp_stream=new ByteArrayInputStream(packet.getData());
		inp=new ObjectInputStream(inp_stream);
		msg=(Message)inp.readObject();


		/* If source address and port of received message is identical to source 
		   address and port of the transport outbound socket, then just discard 
		   the message (if loopback is false) */

		if(loopback == false) {	       
		    InternetAddress  src_addr;
		    Object           tmp=msg.GetSrc();
		    
		    if(tmp == null || !(tmp instanceof Oid))
			System.err.println("UdpMcastReceiverThread.run(): checking loopback: " +
					   "source address is null or not of type Oid");
		    else {
			src_addr=(InternetAddress)((Oid)tmp).GetAddress();
			if(src_addr == null)
			    System.err.println("UdpMcastReceiverThread.run(): checking " + 
					       "loopback: source address is null");
			else {
			    if(local_addr.equals(src_addr)) {
				continue;
			    }
			}
		    }
		}



		/* Discard all messages destined for a channel with a different name */

		Object tmp=msg.GetDest();
		
		if(tmp == null || !(tmp instanceof Oid))
		    System.err.println("UdpMcastReceiverThread.run(): " +
				       "source address is null or not of type Oid");
		else {
		    String ch_name=((Oid)tmp).GetChannelName();
		    if(ch_name == null)
			System.err.println("UdpMcastReceiverThread.run(): " +
					   "channel name is null");
		    else if(!channel_name.equals(ch_name))
			continue;
		}
		
		
		up_prot.Up(msg);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }	    
	}
    }


}
