/* Todo:

   - Get rid of LowLevelCommunication: use events instead
   
*/



package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.net.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



public class TUNNEL extends Protocol implements LowLevelCommunication, Runnable {
    private Properties          properties=null;
    private String              channel_name=null;
    private boolean             trace=false;
    private Vector              members=new Vector();    
    private String              router_host=null;
    private int                 router_port=0;
    private Address             local_addr=null;  // sock's local addr and local port
    private Socket              sock=null;        // connection to JRouter
    private Thread              receiver=null;
    private OutputStream        out_stream=null;
    private ObjectOutputStream  out=null;
    private InputStream         in_stream=null;
    private ObjectInputStream   in=null;


    public TUNNEL() {}



    public String toString() {
	return "Protocol TUNNEL(local_addr=" + local_addr + ")";
    }





    /* ------------------------------ Private methods -------------------------------- */




    public synchronized void HandleIncomingMessage(Message msg) {
	TunnelHeader hdr=(TunnelHeader)msg.RemoveHeader();

	if(trace) Util.Print("TUNNEL.HandleIncomingMessage(): received msg " + msg);
		

	/* Discard all messages destined for a channel with a different name */

	String ch_name=hdr != null ? hdr.channel_name : null;
	if(ch_name != null)
	    if(!channel_name.equals(ch_name))
		return;	    
	
	PassUp(new Event(Event.MSG, msg));	
    }
    
    



    private void HandleDownEvent(Event evt) {
	switch(evt.GetType()) {
	case Event.VIEW_CHANGE:
	    synchronized(members) {
		members.removeAllElements();
		Vector tmpvec=(Vector)evt.GetArg();
		for(int i=0; i < tmpvec.size(); i++)
		    members.addElement(tmpvec.elementAt(i));		
	    }
	    break;
	case Event.GET_LOCAL_ADDRESS:   // return local address -> Event(SET_LOCAL_ADDRESS, local)
	    PassUp(new Event(Event.SET_LOCAL_ADDRESS, local_addr));
	    break;
	case Event.FLUSH:
	    PassUp(new Event(Event.FLUSH_OK));
	    break;
	}
    }



    /* ------------------------------------------------------------------------------- */







    public void run() {
	Object o;

	try {
	    while(true) {
		o=in.readObject();
		if(!(o instanceof Message)) {
		    System.err.println("TUNNEL.run(): received a request of type " +
				       o.getClass().getName() + ", discarding");
		    continue;
		}
		HandleIncomingMessage((Message)o);
	    }
	}
	catch(Exception e) {
	    System.err.println("TUNNEL.run(): " + e);
	}
    }






    /*------------------------------ Protocol interface ------------------------------ */

    public String GetName() {return "TUNNEL";}


    /** Setup the Protocol instance acording to the configuration string */
    public void SetProperties(Properties props) {
	String               str;
	RegistrationRequest  reg;

	this.props=props;
	channel_name=stack.GetChannelName();	
	if(channel_name == null)
	    System.err.println("TUNNEL.SetProperties(): cannot get channel name; will not " +
			       "be able to discard messages destined for different channels");
	
	str=props.getProperty("router_host");
	if(str != null)
	    router_host=new String(str);

	str=props.getProperty("router_port");
	if(str != null)
	    router_port=new Integer(str).intValue();

	str=props.getProperty("trace");
	if(str != null)
	    trace=new Boolean(str).booleanValue();

	if(trace) 
	    Util.Print("TUNNEL(router_host=" + router_host + ";router_port=" + router_port +")");

	if(router_host == null || router_port == 0) {
	    System.err.println("TUNNEL.SetProperties(): both router_host and router_port have " +
			       "to be set !");
	    System.exit(-1);
	}

	if(sock == null) {
	    try {
		sock=new Socket(router_host, router_port);
		out_stream=sock.getOutputStream();
		out=new ObjectOutputStream(out_stream);
		in_stream=sock.getInputStream();
		reg=new RegistrationRequest(channel_name, null);
		out.writeObject(reg);
		out_stream.flush();
		in=new ObjectInputStream(in_stream);
		local_addr=(Address)in.readObject();
		receiver=new Thread(this);
		receiver.start();
	    }
	    catch(Exception e) {
		System.err.println("TUNNEL.SetProperties(): " + e);
		System.exit(-1);
	    }
	}
    }



    /**
     * Caller by the layer above this layer. We just call Route(msg) to pass it on to
     * the remote router.
     */
    public synchronized void Down(Event evt) {
	Message      msg;
	Object       dest_addr, tmp_addr;
	TunnelHeader hdr;

	if(trace) Util.Print("TUNNEL.Down(): event is " + evt);
	
	if(evt.GetType() != Event.MSG) {
	    HandleDownEvent(evt);
	    return;
	}

	hdr=new TunnelHeader(channel_name);
	msg=(Message)evt.GetArg();
	msg.AddHeader(hdr);


	if(msg.GetSrc() == null)
	    msg.SetSrc(local_addr);
       
	try {
	    out.writeObject(msg);
	    out_stream.flush();
	}
	catch(Exception e) {
	    System.err.println("TUNNEL.Down(): " + e);
	}
	
    }





    public void StartWork() {
	channel_name=stack.GetChannelName();	
	if(channel_name == null)
	    System.err.println("TUNNEL.StartWork(): cannot get channel name; will not " +
			       "be able to discard messages destined for different channels");

    }




    public synchronized void StopWork() {
	RegistrationRequest reg=new RegistrationRequest(channel_name, local_addr);
	reg.unregister=true;
	try {
	    out.writeObject(reg);
	    out_stream.flush();
	}
	catch(Exception e) {
	    System.err.println(e);
	}

	if(receiver != null) {
	    receiver.stop();
	    receiver=null;
	}

	try {
	    sock.close();
	    sock=null;
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

    /*--------------------------- End of Protocol interface -------------------------- */






    // Get rid of this crap below !


    /*------------------- LowLevelCommunication interface ---------------------------- */

    public Address GetLocalAddress() {
	return local_addr;
    }

    public Address GetNewMulticastAddress() {
	return null;  // not used
    }

    public void JoinMulticastAddress(Address mcast_address) {
	// not used
    }

    public void LeaveMulticastAddress(Address mcast_address) {
	// not used
    }

    /*----------------- End of LowLevelCommunication interface ----------------------- */




    
    
}
