package JavaGroups.JavaStack.Protocols;

import java.net.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



class Rsp implements java.io.Serializable {
    public Address own_addr=null;
    public Address coord_addr=null;
    
    public Rsp(Address own_addr, Address coord_addr) {
	this.own_addr=own_addr; this.coord_addr=coord_addr;
    }

    public boolean IsCoord() {
	if(own_addr != null && coord_addr != null)
	    return own_addr.equals(coord_addr);
	return false;
    }

    public String toString() {
	return "[own_addr=" + own_addr + ", coord_addr=" + coord_addr + "]";
    }
}






public class GmsImpl {
    private final             int CLIENT_ROLE=0;
    private final             int SERVER_ROLE=1;
    private int               role=CLIENT_ROLE;
    private ViewId            view_id=null, old_view=null;
    private long              highest_vid=0;   // Highest view_id.id seen so far
    private Membership        members=new Membership();
    private GMS               host=null;
    private ProtocolStack     stack=null;
    private boolean           connecting=true, join_received=false, leaving=false;
    private Address           local_addr=null;




    private Address GetLocalAddress() {
	if(local_addr != null)
	    return local_addr;
	local_addr=stack != null ? stack.GetLocalAddress() : null;
	return local_addr;
    }



    private Object SendLeave(Object dest, Address addr, long timeout) throws Exception {
	RemoteMethodCall call=new RemoteMethodCall(host, "Leave", addr);
	return call.Send(dest, false, timeout);
    }



    private void CastViewChange() throws Exception {	
	RemoteMethodCall call=new RemoteMethodCall(host, "ViewChange", view_id, 
						   members.GetMembers());
	call.SendGetN(0, 0);
    }

    private void CastMerge() throws Exception {
	RemoteMethodCall call=new RemoteMethodCall(host, "Merge", (Object)members.GetMembers());
	call.SendGetN(0, 0);
    }

    private void CastSuspect(Address suspected) throws Exception {
	RemoteMethodCall call=new RemoteMethodCall(host, "Suspect", suspected);
	call.SendGetN(0, 0);
    }


    // Check whether local_addr is the first member of the view
    private boolean IsCoordinator() {
	Address first;
	synchronized(members) {
	    first=members.size() > 0 ? (Address)members.elementAt(0) : null;
	    return local_addr.equals(first);
	}       	    
    }

    private Address DetermineCoordinator(Membership mems) {
	return mems != null && mems.size() > 0 ? (Address)mems.elementAt(0) : null;
    }

    // Returns a vector of Rsps
    private Vector PingMembers(int num_responses, long timeout) {
	RemoteMethodCall call=new RemoteMethodCall(host, "Ping");

	try {
	    return call.SendGetN(num_responses, timeout);  // get first 3, wait 1 sec
	}
	catch(Exception e) {
	    System.err.println(e);
	    return null;
	}
    }

    // Returns a vector of Rsps
    private Vector PingMembersUsingGossip(int num_responses, long timeout) {
	Vector gossip_rsps;
	
	gossip_rsps=host.FindInitialMembers(stack.GetChannelName());
	if(gossip_rsps.size() == 0) 
	    return gossip_rsps;


	// Set a temporary membership in the UDP layer, so that the following multicast
	// will be sent to all of them
	Event view_event=new Event(Event.VIEW_CHANGE, gossip_rsps);
	if(host != null)
	    host.PassDown(view_event); // needed e.g. by failure detector or UDP	

 	RemoteMethodCall call=new RemoteMethodCall(host, "Ping");

 	try {
 	    return call.SendGetN(num_responses, timeout);  // get first 3, wait 1 sec
 	}
 	catch(Exception e) {
 	    System.err.println(e);
 	    return null;
 	}

    }


    private void RemoveMyself(Vector mems) {
	Rsp mbr;
	for(int i=0; i < mems.size(); i++) {
	    mbr=(Rsp)mems.elementAt(i);
	    if(mbr == null)
		continue;

	    if(mbr.own_addr == null) {
		mems.removeElement(mbr);
		continue;
	    }

	    if(local_addr.equals(mbr.own_addr)) {
		mems.removeElement(mbr);
		return;
	    }
	}
    }

    private Address FindCoord(Vector mbrs) {
	Rsp mbr;
	if(mbrs == null || mbrs.size() < 1)
	    return null;

	for(int i=0; i < mbrs.size(); i++) {
	    mbr=(Rsp)mbrs.elementAt(i);
	    if(mbr.coord_addr != null)
		return mbr.coord_addr;
	}
	return null;
    }


    private long Max(long x, long y) {return x > y ? x : y;}

    /** Return the highest VID seen so far, incremented by 1 */
    private void Increment(ViewId vid) {
	long new_vid=Max(vid.GetId(), highest_vid);
	vid.SetId(++new_vid);
	highest_vid=new_vid;
    }

    /** Returns true if local_addr is member of mbrs, else false */
    private boolean CheckSelfInclusion(Vector mbrs) {
	Address mbr;
	if(mbrs == null)
	    return false;
	for(int i=0; i < mbrs.size(); i++) {
	    mbr=(Address)mbrs.elementAt(i);
	    if(mbr != null && local_addr.equals(mbr))
		return true;
	}
	return false;
    }



    /*-----------------------------------------------------------------------------*/
    /*----------------------------- Public members --------------------------------*/
    /*-----------------------------------------------------------------------------*/


    public GmsImpl(GMS host) {
	this.host=host;
	if(host != null)
	    stack=host.GetProtocolStack();
	local_addr=GetLocalAddress();
    }


    public ViewId  GetViewId()  {return view_id;}


    public Rsp Ping() {
	return role == CLIENT_ROLE ? new Rsp(local_addr, local_addr) : 
        	                     new Rsp(local_addr, DetermineCoordinator(members));
    }

    



    /**
     * Called by non-member (client) to join a group. Will result in a unicast Join message
     * to be sent to the coordinator.
     */
    public void StartJoin() {
	RemoteMethodCall  call;
	RepeatedUnicast   rep_cast;
	Event             view_event;
	Vector            initial_members, tmp;
	Address           coord;
	Boolean           retval;

	if(stack == null)
	    stack=host.GetProtocolStack();	
	local_addr=GetLocalAddress();
	
	Util.Print("\n----------------------------------------------------------\n" +
		   "GmsImpl.StartJoin(): my address is " + local_addr + 
		   "\n----------------------------------------------------------");

	view_id=new ViewId(local_addr);
	old_view=view_id.Copy();        // initial copy
	members.Add(local_addr);

	view_event=new Event(Event.VIEW_CHANGE, members.GetMembers());
	if(host != null) {
	    host.PassUp(view_event);
	    host.PassDown(view_event); // needed e.g. by failure detector or UDP
	}


	while(true) {
	    if(host.UseGossip()) {
		Util.Print("GmsImpl.StartJoin(): pinging for members using gossip (wait=" + 
			   host.GetPingTime() + ")");
		initial_members=PingMembersUsingGossip(host.GetPingNum(), host.GetPingTime());
	    }
	    else {
		Util.Print("GmsImpl.StartJoin(): pinging for members using ip multicast (wait=" +
			   host.GetPingTime() + ")");
		initial_members=PingMembers(host.GetPingNum(), host.GetPingTime());
	    }

	    if(initial_members == null) {
		Util.Print("GmsImpl.StartJoin(): found no members (return value was null) !");
		break;
	    }


	    RemoveMyself(initial_members);


	    if(initial_members.size() == 0) {  // Assume I'm first member in group
		Util.Print("GmsImpl.StartJoin(): found no members; I assume I'm the first member.");
		break;
	    }
	    else {	       
		Util.Print("GmsImpl.StartJoin(): found members " + initial_members);
		coord=FindCoord(initial_members);
		if(coord != null) {  // coordinator among the respondents
		    call=new RemoteMethodCall(host, "Join", local_addr);

		    try {
			retval=(Boolean)call.Send(coord, false, 3000);
			if(retval != null && retval.booleanValue() == true) {
			    System.out.println("Join request sent to " + coord + " succeeded");
			    break;
			}
			else { // coord is not the coord anymore (coord change after FindCoord)
			    System.err.println("Join request sent to " + coord + " failed, " +
					       "continuing");
			    continue;
			}
		    }
		    catch(TimeoutException tex) {
			try {
			    CastSuspect(coord);  // will remove coord from membership
			}
			catch(Exception e) {
			    System.err.println("GmsImpl.Join() " + e);
			}
		    }
		    catch(Exception e) {
			System.err.println("GmsImpl.StartJoin(): " + e);
			break;
		    }
		}
		else  // coordinator not among the respondents, first mbr of grp
		    continue; // break; ??
	    }	    
	}
	Util.Print("GmsImpl.StartJoin(): done");

	if(join_received) {
	    try {
		CastMerge();
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
	role=SERVER_ROLE;
    }






    
    /**
     * Will always be called via unicast message ! Should NOT be called via mcast, because
     * every non-coordinator would try to forward to the coord, resulting in a broadcast storm !
     */
    public boolean Join(Address new_member) {
	Boolean  retval=null;
	Address  coord;

	if(role == CLIENT_ROLE) {	    
	    if(local_addr.equals(new_member))
		return false;
	    members.Add(new_member);
	    join_received=true;
	    // return false;
	    return true; // ??????????????????????????/
	}

	if(IsCoordinator()) {  // Coordinator
	    if(local_addr.equals(new_member)) {
		System.err.println("GmsImpl.Join(): coordinator already joined !");
		return true;
	    }

	    Increment(view_id);
	    if(!local_addr.equals(view_id.GetCoordAddress()))
		view_id.SetCoordAddress(local_addr);
	    members.Add(new_member);
	    try {

		// Set temporary membership in UDP layer so that multicast gets sent to
		// the correct destinations
		Event view_event=new Event(Event.VIEW_CHANGE, members.GetMembers());
 		if(host != null)
 		    host.PassDown(view_event); // needed e.g. by failure detector or UDP

		CastViewChange();
		return true;
	    }
	    catch(Exception e) {
		System.err.println("GmsImpl.Join(): " + e);
		return false;
	    }
	}
	else       // Not Coordinator
	    return false;
    }




    /**
     * Called by members that want to leave group. Will in turn send a unicast Leave message to
     * the coordinator.
     */
    public void StartLeave(Address mbr) {
	Address   coord;
	Boolean   retval;
	int       numtries=5;
	Event     leave_ok=new Event(Event.LEAVE_OK);

	if(mbr.equals(GetLocalAddress()))
	    leaving=true;

	while((coord=DetermineCoordinator(members)) != null && numtries-- > 0) {

	    if(local_addr.equals(coord)) {
		Leave(mbr);
		break;
	    }
		
	    try {
		retval=(Boolean)SendLeave(coord, mbr, 3000);
		if(retval != null && retval.booleanValue() == true) {
		    System.out.println("Leave request sent to " + coord + " succeeded");
		    break;
		}
		else {
		    members.Remove(coord);
		    System.out.println("Leave request sent to " + coord + " failed, continuing...");
		    continue;
		}
	    }
	    catch(TimeoutException tex) {
		try {
		    CastSuspect(coord);  // will remove coord from membership
 		}
 		catch(Exception e) {
 		    System.err.println("GmsImpl.StartLeave() " + e);
 		}

	    }
	    catch(Exception e) {
		System.err.println("GmsImpl.StartLeave(): " + e);
	    }			      
	}

	host.PassUp(leave_ok);
    }




    /**
     * Will always be called via unicast message ! Should NOT be called via mcast, because
     * every non-coordinator would try to forward to the coord, resulting in a broadcast storm !
     */
    public boolean Leave(Address addr) {
	Boolean  retval=null;
	Address  coord;

	if(role == CLIENT_ROLE) {  // should never happen !
	    members.Remove(addr);
	    return false;
	}

	if(IsCoordinator()) {
	    if(local_addr.equals(addr))
		System.err.println("GmsImpl.Leave(): coordinator itself is leaving");

	    Increment(view_id);
	    
	    if(!local_addr.equals(view_id.GetCoordAddress()))
		view_id.SetCoordAddress(local_addr);

	    members.Remove(addr);
	    try {
		// Set temporary membership in UDP layer (and others !) so that multicast gets sent to
		// the correct destinations
		//Event view_event=new Event(Event.VIEW_CHANGE, members.GetMembers());  // +++
 		//if(host != null) // +++
 		//    host.PassDown(view_event); // needed e.g. by UDP, MACK // +++

		CastViewChange();
		return true;
	    }
	    catch(Exception e) {
		System.err.println("GmsImpl.Leave(): " + e);
		return false;
	    }
	}
	else
	    return false;	    
    }





    public synchronized void ViewChange(ViewId new_view, Vector mems) {
	Address coord;

	highest_vid=Max(new_view.GetId(), highest_vid);

	/* Check for self-inclusion: if I'm not part of the new membership, I just discard it */
	if(CheckSelfInclusion(mems) == false) {
	    System.err.println("GMS.ViewChange(): I'm not member of " + mems + ", discarding");
	    return;
	}

	int rc=new_view.Compare(old_view);  // rc should always be a positive number

	if(leaving)
	    return;


	Util.Print("VIEW is " + new_view + ", members are " + mems);

	if(rc <= 0) {
	    Util.Print("ViewChange, rc is " + rc);
	    // Util.DumpStack(true);
	}

	if(mems.size() == 0) {
	    Util.Print("GmsImpl.ViewChange(): size of members is 0 !");
	    // Util.DumpStack(true);
	    return;
	}

	if(role == CLIENT_ROLE) {
	    view_id.SetCoordAddress(new_view.GetCoordAddress());
	    view_id.SetId(new_view.GetId());	    
	    old_view=view_id.Copy();	    
	    members.Set(mems);
	}
	else {

	    coord=DetermineCoordinator(members);	    
	    
	    if(IsCoordinator()) {  // coordinator

		/* If I'm the coordinator (I think !), and receive a ViewChange with someone else
		   as coordinator, I cast a Merge request */
		if(!local_addr.equals(new_view.GetCoordAddress())) {
		    members.Merge(mems);
		    try {
			CastMerge();
		    }
		    catch(Exception e) {
			System.err.println(e);
		    }
		}
		else {
		    view_id.SetCoordAddress(new_view.GetCoordAddress());
		    view_id.SetId(new_view.GetId());		    
		    old_view=view_id.Copy();		    
		    members.Set(mems);
		}
	    }

	    else {                                           // not coordinator
		view_id.SetCoordAddress(new_view.GetCoordAddress());
		view_id.SetId(new_view.GetId());		
		old_view=view_id.Copy();		
		members.Set(mems);
	    }

	}

	// Send VIEW_CHANGE event up and down the stack:

	Event view_event=new Event(Event.VIEW_CHANGE, mems);
	if(host != null) {
	    host.PassUp(view_event);
	    host.PassDown(view_event); // needed e.g. by failure detector or UDP
	}

	if(connecting)
	    connecting=false;
    }





    public synchronized void Merge(Vector mems) throws Exception {
	members.Merge(mems);
	members.Sort();
	Util.Print("MERGING, members are " + members);

	Event view_event=new Event(Event.VIEW_CHANGE, members.GetMembers());
	if(host != null) {
	    host.PassUp(view_event);
	}

    }



    public synchronized void Suspect(Address suspected_mbr) throws Exception {
	if(suspected_mbr != null) {
	    if(local_addr.equals(suspected_mbr)) {
		Util.Print("GmsImpl.Suspect(): I'm suspected though still alive ! Terminating...");
		// Util.DumpStack(true);
	    }
	    members.Remove(suspected_mbr);
	}
	// members.Sort(); // ?????????
    }




}
