
/* Todo:

   - Discard messages from members not in our current view (?)

*/


package JavaGroups.JavaStack.Protocols;

import java.io.Serializable;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;


class GmsHeader implements Serializable {
    public ViewId   view_id=null;
    public boolean  handle=false;

    public GmsHeader(ViewId v, boolean h) {
	view_id=v;
	handle=h;
    }

    public String toString() {
	return "[GMS: view_id=" + view_id + ", handle=" + handle + "]";
    }
}



public class GMS extends Protocol implements Transportable {
    public  final int       type=Conf.GMS_MSG;
    private Properties      props=null;
    private GmsImpl         gms_impl=null;
    private MethodInvoker   method_invoker=new MethodInvoker(this, false);
    private String          channel_name=null;
    private Queue           rsp_queue=new Queue();
    private String          gossip_host=null;
    private int             gossip_port=0;
    private GossipClient    gossip=null;
    private boolean         gossiping=false;
    private long            ping_time=3000;
    private int             ping_num=10;



    public GMS() {
	method_invoker.SetMethodLookup(new MethodLookupClos());
	gms_impl=new GmsImpl(this);
	method_invoker.AddTargetObject(gms_impl);
    }


    public ProtocolStack GetProtocolStack()    {return stack;}
    public String        GetName()             {return "GMS";}
    public boolean       UseGossip()           {return gossiping;}
    public long          GetPingTime()         {return ping_time;}
    public int           GetPingNum()          {return ping_num;}

    public Vector        FindInitialMembers(String channel_name) {
	if(gossip != null)
	    return gossip.Get(channel_name);
	else
	    System.err.println("GMS.FindInitialMembers(): gossip is null !");
	return new Vector();
    }


    public void Join(Address new_member) {
	gms_impl.Join(new_member);
    }

    public void Leave(Address member) {
	gms_impl.Leave(member);
    }



    /*-------------------------- Interface Transportable -------------------------------*/

    /** 
	Used e.g. by MethodInvoker to return a response. Tag the message with our type, 
	this result in our the message being caught by the corresponding GMS layer in 
	the other protocol stack(s).
	The assumption here is that all messages sent using the <code>Send</code> method 
	will always only be sent to other GMSs ! If this is not the case, then the 
	<code>Down</code> method should be used, with the 
	<code>type</code> field set accordingly 
    */
    public void Send(Message msg) throws Exception {
	Address    dest=(Address)msg.GetDest();
	GmsHeader  hdr=new GmsHeader(null, true);
	msg.AddHeader(hdr);	
	Down(new Event(Event.MSG, msg));
    }



    
    /** Remove a message from the rsp_queue */
    public Message Receive(long timeout) throws Exception {
	try {
	    return (Message)rsp_queue.Remove(timeout);
	}
	catch(TimeoutException tex) {
	    throw tex;
	}
	catch(QueueClosed closed) {
	    return null;
	}
	catch(Exception e) {
	    System.err.println("GMS.Receive(): " + e);
	}
	return null;
    }

    /*----------------------------------------------------------------------------------*/







    /*------------------------------- Interface Protocol -------------------------------*/
    /**
     * In case of a request, forward the message to the method invoker. In case of a response,
     * put it on the response queue, to be retrieved by later Receive() calls.
     */
    public void Up(Event evt) {
	int        msg_type;
	Message    msg;
	GmsHeader  hdr;

	if(evt.GetType() != Event.MSG) {
	    HandleUpEvent(evt);
	    return;
	}
	
	msg=(Message)evt.GetArg();

	hdr=(GmsHeader)msg.RemoveHeader();
	// Do something with the view_id


	try {	    
	    if(hdr.handle == true) {
		if(msg.IsResponse())
		    rsp_queue.Add(msg);
		else
		    method_invoker.Receive(msg);
		return;
	    }
	    PassUp(evt);
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }

	
    private void HandleUpEvent(Event evt) {
	switch(evt.GetType()) {

	case Event.SUSPECT:  // todo: treat this differently in the future !
	case Event.LEAVE:                                // will be received before FLUSH
	    gms_impl.StartLeave((Address)evt.GetArg());  // gms_impl will generate LEAVE_OK event
	    break;

	default:
	    PassUp(evt);
	}	
    }



    public void Down(Event evt) {	
	Message  msg;
	Object   hdr;

	if(evt.GetType() != Event.MSG) {
	    HandleDownEvent(evt);
	    return;
	}

	/* If a GmsHeader has already been added (by 'Send') -> update it with the view id.
	   Otherwise, add a new GmsHeader with the view id */

	msg=(Message)evt.GetArg();	
	hdr=msg.PeekHeader();
	if(hdr != null && hdr instanceof GmsHeader)
	    ((GmsHeader)hdr).view_id=gms_impl.GetViewId();
	else
	    msg.AddHeader(new GmsHeader(gms_impl.GetViewId(), false));
	PassDown(evt);
    }


	
    private void HandleDownEvent(Event evt) {

	switch(evt.GetType()) {

	case Event.JOIN:
	    gms_impl.StartJoin();
	    break;

	case Event.SUSPECT:   // todo:  treat this differently in the future !
	case Event.LEAVE:                                // will be received before FLUSH
	    gms_impl.StartLeave((Address)evt.GetArg());  // gms_impl will generate LEAVE_OK event
	    break;

	case Event.FLUSH:   // will be received after LEAVE
	    PassDown(evt);
	    break;
	    
	default:
	    PassDown(evt);
	}
	
    }


    public void StartWork() {
	Address local_addr;

	if(stack != null)
	    channel_name=stack.GetChannelName();
	if(gms_impl == null) {
	    System.err.println("GMS.StartWork(): gms_impl is null");
	    return;
	}
	if(gossiping) {
	    if(gossip == null) {
		gossip=new GossipClient(stack.GetChannelName(), gossip_host, gossip_port);
		local_addr=stack != null ? stack.GetLocalAddress() : null;
		if(local_addr != null)
		    gossip.Register(local_addr);
		else
		    System.err.println("GMS.StartWork(): starting gossip client, but local " +
				       "address is null !");
		gossip.Start();
	    }
	}
    }

    public void StopWork() {
	if(gossip != null) {
	    gossip.Stop();
	    gossip=null;
	}
	if(method_invoker != null)
	    method_invoker.RemoveAllTargetObjects();
    }


 /** Setup the Protocol instance acording to the configuration string */
    public void SetProperties(Properties props) {
	String     str;
	this.props=props;

	str=props.getProperty("gossip_host");
	if(str != null)
	    gossip_host=new String(str);

	str=props.getProperty("gossip_port");
	if(str != null)
	    gossip_port=new Integer(str).intValue();

	if(gossip_host != null && gossip_port != 0)
	    gossiping=true;


	str=props.getProperty("ping_time");
	if(str != null)
	    ping_time=new Long(str).longValue();

	str=props.getProperty("ping_num");
	if(str != null)
	    ping_num=new Integer(str).intValue();

    }



    public String toString() {
	return "Protocol GMS";
    }

    /*----------------------------------------------------------------------------------*/


}
