package JavaGroups.JavaStack.Protocols;

import java.util.Properties;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

/**
 * Example of a protocol layer. Contains no real functionality, can be used as a template.
 */

public class EXAMPLE extends Protocol {
    boolean trace=false;

    public String  GetName() {return "EXAMPLE";}


    public void SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null)
	    trace=new Boolean(str).booleanValue();
    }


    /** Just remove if you don't need to reset any state */
    public void Reset() {}

    /** Just remove if no initialization of state / or starting of threads */
    public void StartWork() {}

    /** Just remove if no removal of state / or stopping of threads */
    public void StopWork() {}


    public void Up(Event evt) {
	Message msg;

	if(evt.GetType() == Event.MSG) {
	    msg=(Message)evt.GetArg();

	    // Do something with the event, e.g. extract the message and remove a header.

	}

	PassUp(evt); // Pass up to the layer above us
    }



    public void Down(Event evt) {
	Message msg;

	if(evt.GetType() == Event.MSG) {
	    msg=(Message)evt.GetArg();

	    // Do something with the event, e.g. add a header to the message

	}

	PassDown(evt);  // Pass on to the layer below us
    }


}
